/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.jaxrs;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.coodex.concrete.ClientException;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractSyncInvoker;
import org.coodex.concrete.client.jaxrs.JaxRSClientContext;
import org.coodex.concrete.client.jaxrs.JaxRSClientException;
import org.coodex.concrete.client.jaxrs.JaxRSDestination;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.JaxRSSubjoin;
import org.coodex.concrete.jaxrs.logging.ClientLogger;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.mock.Mocker;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRSInvoker
extends AbstractSyncInvoker {
    private static final Logger log = LoggerFactory.getLogger(JaxRSInvoker.class);
    private final Client client;

    JaxRSInvoker(JaxRSDestination destination) {
        super((Destination)destination);
        ClientBuilder clientBuilder = (ClientBuilder)ClientBuilder.newBuilder().register(ClientLogger.class);
        this.client = destination.isSsl() ? clientBuilder.hostnameVerifier((s, sslSession) -> true).sslContext(ClientHelper.getSSLContext((String)destination.getSsl())).build() : clientBuilder.build();
    }

    private Invocation.Builder buildHeaders(Invocation.Builder builder, Subjoin subjoin, String tokenId) {
        JaxRSClientContext context = this.getContext();
        builder = builder.acceptLanguage(new Locale[]{context.getLocale()});
        if (subjoin != null || !Common.isBlank((String)tokenId)) {
            if (subjoin != null) {
                for (String key : subjoin.keySet()) {
                    builder = builder.header(key, (Object)subjoin.get(key));
                }
            }
            if (!Common.isBlank((String)tokenId)) {
                builder = builder.header("CONCRETE-TOKEN-ID", (Object)tokenId);
            }
        }
        return builder;
    }

    private static JaxRSClientException throwException(boolean errorOccurred, int code, String body, JaxrsUnit unit, String url) {
        if (errorOccurred) {
            ErrorInfo errorInfo = (ErrorInfo)ClientHelper.getJSONSerializer().parse(body, ErrorInfo.class);
            return new JaxRSClientException(errorInfo.getCode(), errorInfo.getMsg(), url, unit.getInvokeType());
        }
        return new JaxRSClientException(code, body, url, unit.getInvokeType());
    }

    private static Object processResult(int code, String body, JaxrsUnit unit, boolean errorOccurred, String url) {
        if (code >= 200 && code < 300) {
            return code == 204 || Void.TYPE.equals(unit.getReturnType()) ? null : ClientHelper.getJSONSerializer().parse(body, GenericTypeHelper.toReference((Type)unit.getGenericReturnType(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass()));
        }
        throw JaxRSInvoker.throwException(errorOccurred, code, body, unit, url);
    }

    private static Object getSubmitObject(JaxrsUnit unit, Object[] args) {
        HashMap<String, Object> toSubmit = null;
        JaxrsParam[] pojoParams = unit.getPojo();
        if (args != null) {
            switch (pojoParams.length) {
                case 0: {
                    break;
                }
                case 1: {
                    toSubmit = args[pojoParams[0].getIndex()];
                    break;
                }
                default: {
                    HashMap<String, Object> body = new HashMap<String, Object>();
                    for (JaxrsParam param : pojoParams) {
                        body.put(param.getName(), args[param.getIndex()]);
                    }
                    toSubmit = body;
                }
            }
        }
        return toSubmit;
    }

    private String getEncodingCharset() {
        String charset = ((JaxRSDestination)this.getDestination()).getCharset();
        if (charset == null) {
            charset = "utf-8";
        }
        try {
            return Charset.forName(charset).displayName();
        }
        catch (UnsupportedCharsetException e) {
            log.warn("Unsupported charset: {}\uff0c use \"UTF-8\"", (Object)charset);
            return "utf-8";
        }
    }

    private String encode(String s, String charset) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == ' ') {
                builder.append("%20");
                continue;
            }
            builder.append(URLEncoder.encode(String.valueOf(c), charset));
        }
        return builder.toString();
    }

    private String toStr(Object o) {
        if (o == null) {
            return null;
        }
        if (TypeHelper.isPrimitive(o.getClass())) {
            return o.toString();
        }
        return ClientHelper.getJSONSerializer().toJson(o);
    }

    protected Object execute(Class clz, Method method, Object[] args) throws Throwable {
        JaxrsUnit unit = JaxRSHelper.getUnitFromContext((DefinitionContext)ConcreteHelper.getContext((Method)method, (Class)clz));
        if (ConcreteHelper.isDevModel((String)"jaxrs.client")) {
            return Mocker.mockMethod((Method)unit.getMethod(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass());
        }
        String path = this.getDestination().getLocation();
        StringTokenizer stringTokenizer = new StringTokenizer(((JaxrsModule)unit.getDeclaringModule()).getName() + "/" + unit.getName(), "/");
        StringBuilder builder = new StringBuilder();
        while (stringTokenizer.hasMoreElements()) {
            String node = stringTokenizer.nextToken();
            if (Common.isBlank((String)node)) continue;
            builder.append("/");
            if (node.startsWith("{") && node.endsWith("}")) {
                String paramName = new String(node.toCharArray(), 1, node.length() - 2);
                JaxrsParam[] params = (JaxrsParam[])unit.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    JaxrsParam param = params[i];
                    if (!paramName.equals(param.getName())) continue;
                    node = this.toStr(args[i]);
                    break;
                }
            }
            builder.append(this.encode(node, this.getEncodingCharset()));
        }
        path = path + builder.toString();
        Object toSubmit = JaxRSInvoker.getSubmitObject(unit, args);
        try {
            Response response = this.request(path, unit.getInvokeType(), toSubmit);
            String tokenId = response.getHeaderString("CONCRETE-TOKEN-ID");
            ClientTokenManagement.setTokenId((Destination)this.getDestination(), (String)tokenId);
            String body = (String)response.readEntity(String.class);
            JaxRSSubjoin subjoin = new JaxRSSubjoin(response.getHeaders());
            String warnings = subjoin.get("CONCRETE-WARNINGS");
            if (!Common.isBlank((String)warnings)) {
                subjoin.set("CONCRETE-WARNINGS", Collections.singletonList(URLDecoder.decode(warnings, "UTF-8")));
            }
            this.getContext().responseSubjoin((Subjoin)subjoin);
            return JaxRSInvoker.processResult(response.getStatus(), body, unit, response.getHeaders().containsKey((Object)"CONCRETE-ERROR-OCCURRED"), path);
        }
        catch (ClientException clientEx) {
            throw clientEx;
        }
        catch (Throwable th) {
            JaxRSClientException ce = new JaxRSClientException(-1, th.getLocalizedMessage(), path, unit.getInvokeType());
            ce.initCause(th);
            throw ce;
        }
    }

    private JaxRSClientContext getContext() {
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        if (serviceContext instanceof JaxRSClientContext) {
            return (JaxRSClientContext)serviceContext;
        }
        throw new RuntimeException(serviceContext + " is NOT JaxRSClientContext");
    }

    private Response request(String url, String method, Object body) {
        Invocation.Builder builder = this.getInvokerBuilder(url);
        return body == null ? builder.build(method).invoke() : builder.build(method, Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE.withCharset(this.getEncodingCharset()))).invoke();
    }

    private Invocation.Builder getInvokerBuilder(String url) {
        Invocation.Builder builder = this.client.target(url).request();
        JaxRSClientContext context = this.getContext();
        Subjoin subjoin = context.getSubjoin();
        String tokenId = ClientTokenManagement.getTokenId((Destination)this.getDestination(), (String)context.getTokenId());
        return this.buildHeaders(builder, subjoin, tokenId);
    }

    public ServiceContext buildContext(DefinitionContext context) {
        return new JaxRSClientContext(this.getDestination(), context);
    }
}

