/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.util.Common;
import org.coodex.util.Profile;

public class Predicates {
    private static final String[] PREDICATES_PUT_DEFAULT = new String[]{"update", "set"};
    private static final String[] PREDICATES_GET_DEFAULT = new String[]{"new", "get", "findBy"};
    private static final String[] PREDICATES_DELETE_DEFAULT = new String[]{"delete"};
    private static final String[] PREDICATES_POST_DEFAULT = new String[]{"save"};
    private static final String[] PREDICATES_PUT = Predicates.getProfile().getStrList("service.predicates.PUT", ",", PREDICATES_PUT_DEFAULT);
    private static final String[] PREDICATES_GET = Predicates.getProfile().getStrList("service.predicates.GET", ",", PREDICATES_GET_DEFAULT);
    private static final String[] PREDICATES_DELETE = Predicates.getProfile().getStrList("service.predicates.DELETE", ",", PREDICATES_DELETE_DEFAULT);
    private static final String[] PREDICATES_POST = Predicates.getProfile().getStrList("service.predicates.POST", ",", PREDICATES_POST_DEFAULT);
    public static final String[][] PREDICATES = new String[][]{PREDICATES_PUT, PREDICATES_DELETE, PREDICATES_POST, PREDICATES_GET};
    public static final String[] HTTP_METHOD = new String[]{"PUT", "DELETE", "POST", "GET"};

    private static Profile getProfile() {
        return Profile.getProfile((String)"jaxrs.predicates.properties");
    }

    public static String getHttpMethod(Unit unit) {
        String methodName = unit.getMethod().getName();
        int methodIndex = -1;
        String lastCheck = null;
        for (int i = 0; i < PREDICATES.length; ++i) {
            for (int j = 0; j < PREDICATES[i].length; ++j) {
                int l;
                if (!methodName.startsWith(PREDICATES[i][j])) continue;
                int n = l = lastCheck == null ? 0 : lastCheck.length();
                if (PREDICATES[i][j].length() <= l) continue;
                methodIndex = i;
                lastCheck = PREDICATES[i][j];
            }
        }
        if (methodIndex >= 0) {
            return HTTP_METHOD[methodIndex];
        }
        return JaxRSHelper.getSubmitBody(unit) == null ? "GET" : "POST";
    }

    private static String[] paths(String methodName) {
        StringTokenizer st = new StringTokenizer(methodName, "/\\");
        ArrayList<String> cache = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String s = st.nextToken().trim();
            if (Common.isBlank((String)s)) continue;
            cache.add(s);
        }
        return cache.toArray(new String[0]);
    }

    private static String buildPath(String[] paths) {
        StringBuilder builder = new StringBuilder();
        for (String s : paths) {
            if (Common.isBlank((String)s)) continue;
            if (builder.length() > 0) {
                builder.append('/');
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public static final String removePredicate(String name) {
        String[][] stringArray = PREDICATES;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] predicates;
            for (String predicate : predicates = stringArray[i]) {
                if (!name.startsWith(predicate)) continue;
                return Common.lowerFirstChar((String)name.substring(predicate.length()));
            }
        }
        return name;
    }

    private static int getLastNodeIndex(String[] paths) {
        int index = -1;
        for (int i = paths.length - 1; i >= 0; --i) {
            String s = paths[i].trim();
            if (s.startsWith("{") && s.endsWith("}")) continue;
            index = i;
            break;
        }
        return index;
    }
}

