/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.struct;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.struct.AbstractModule;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.Predicates;
import org.coodex.concrete.jaxrs.saas.RouteBy;
import org.coodex.concrete.jaxrs.struct.Param;
import org.coodex.concrete.jaxrs.struct.Unit;

public class Module
extends AbstractModule<Unit> {
    private Map<String, Method> serviceAtoms;

    protected final boolean sameMethod(Method m1, Method m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.equals(m2) || m1.getName().equals(m2.getName()) && Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public Module(Class<?> interfaceClass) {
        super(interfaceClass);
    }

    private void checkUnit(Unit unit) {
        String fullResource = this.getName() + unit.getName();
        Matcher m = Pattern.compile("(\\{)[^{^}]{0,256}(\\})").matcher(fullResource);
        while (m.find()) {
            String param = m.group();
            if (this.findPathParam(unit, param = param.substring(1, param.length() - 1).trim())) continue;
            throw new RuntimeException("path param [" + param + "] not found in " + this.getInterfaceClass().getName() + "." + unit.getMethod().getName());
        }
        RouteBy routeBy = (RouteBy)unit.getAnnotation(RouteBy.class);
        if (routeBy != null) {
            String routeByParam = routeBy.value();
            boolean found = false;
            for (Param param : (Param[])unit.getParameters()) {
                if (!param.isPathParam() || !param.getName().equals(routeByParam)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException("routeBy [" + routeByParam + "] not found in " + this.getInterfaceClass().getName() + "." + unit.getMethod().getName());
            }
        }
    }

    private boolean findPathParam(Unit unit, String param) {
        for (Param p : (Param[])unit.getParameters()) {
            if (!p.isPathParam() || !param.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return JaxRSHelper.slash(JaxRSHelper.camelCaseByPath(ConcreteHelper.getServiceName((Class)this.getInterfaceClass()), true));
    }

    protected Unit[] toArrays(List<Unit> units) {
        Unit[] array = units.toArray(new Unit[0]);
        Arrays.sort((Object[])array);
        return array;
    }

    protected Unit buildUnit(Method method) {
        Unit unit;
        String serviceKey;
        Method exists;
        if (this.serviceAtoms == null) {
            this.serviceAtoms = new HashMap<String, Method>();
        }
        if (this.sameMethod(method, exists = this.serviceAtoms.get(serviceKey = Predicates.getHttpMethod(unit = new Unit(method, this)) + "$" + unit.getName()))) {
            return null;
        }
        if (exists != null) {
            throw new RuntimeException(String.format("Method Conflict [%s]. m1:%s.%s, m2:%s.%s", serviceKey, method.getDeclaringClass().getName(), method.getName(), exists.getDeclaringClass().getName(), exists.getName()));
        }
        this.checkUnit(unit);
        this.serviceAtoms.put(serviceKey, method);
        return unit;
    }

    public int compareTo(AbstractModule o) {
        return this.getName().compareTo(o.getName());
    }
}

