/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.coodex.concrete.api.Abstract;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.jaxrs.BigString;
import org.coodex.concrete.jaxrs.Body;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Param;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.coodex.util.TypeHelper;

public class JaxRSHelper {
    public static final String HEADER_ERROR_OCCURRED = "CONCRETE-ERROR-OCCURRED";
    public static final String KEY_CLIENT_PROVIDER = "X-CLIENT-PROVIDER";
    private static final Map<Class<?>, Module> MODULE_CACHE = new HashMap();

    @Deprecated
    public static boolean isPrimitive(Class c) {
        return TypeHelper.isPrimitive((Class)c);
    }

    public static boolean postPrimitive(Param param) {
        return param.getDeclaredAnnotation(Body.class) != null;
    }

    @Deprecated
    public static boolean isBigString(Param param) {
        return String.class.isAssignableFrom(param.getType()) && param.getDeclaredAnnotation(BigString.class) != null;
    }

    @Deprecated
    public static String lowerFirstChar(String string) {
        return Common.lowerFirstChar((String)string);
    }

    @Deprecated
    public static String upperFirstChar(String string) {
        return Common.upperFirstChar((String)string);
    }

    @Deprecated
    public static String camelCase(String s) {
        return JaxRSHelper.camelCase(s, false);
    }

    @Deprecated
    public static String camelCase(String s, String delimiters) {
        return JaxRSHelper.camelCase(s, false, delimiters);
    }

    @Deprecated
    public static String camelCase(String s, boolean firstCharUpperCase) {
        return Common.camelCase((String)s, (boolean)firstCharUpperCase);
    }

    @Deprecated
    public static String camelCase(String s, boolean firstCharUpperCase, String delimiters) {
        return Common.camelCase((String)s, (boolean)firstCharUpperCase, (String)delimiters);
    }

    public static String camelCaseByPath(String s) {
        return JaxRSHelper.camelCaseByPath(s, false);
    }

    public static String camelCaseByPath(String s, boolean firstCharUpperCase) {
        StringTokenizer st = new StringTokenizer(s, "/");
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreElements()) {
            String node = st.nextToken();
            if (node.length() == 0) continue;
            builder.append('/').append(Common.camelCase((String)node, (boolean)firstCharUpperCase, (String)".-_ "));
        }
        return builder.toString();
    }

    public static final synchronized Module getModule(final Class<? extends ConcreteService> type, String ... packages) {
        Module module = MODULE_CACHE.get(type);
        if (module == null) {
            if (type.getAnnotation(Abstract.class) != null) {
                if (packages == null || packages.length == 0) {
                    packages = ConcreteHelper.getApiPackages();
                }
                final HashSet serviceType = new HashSet();
                ReflectHelper.foreachClass((ReflectHelper.Processor)new ReflectHelper.Processor(){

                    public void process(Class<?> serviceClass) {
                        if (serviceClass.isInterface() && type.isAssignableFrom(serviceClass) && serviceClass.getAnnotation(Abstract.class) == null) {
                            serviceType.add(serviceClass);
                        }
                    }
                }, (ClassNameFilter)new ClassNameFilter(){

                    public boolean accept(String className) {
                        return true;
                    }
                }, (String[])packages);
                switch (serviceType.size()) {
                    case 0: {
                        throw new ConcreteException(1001, new Object[]{type});
                    }
                    case 1: {
                        module = new Module((Class)serviceType.iterator().next());
                        break;
                    }
                    default: {
                        throw new ConcreteException(1018, new Object[]{type});
                    }
                }
            } else {
                module = new Module(type);
            }
            MODULE_CACHE.put(type, module);
        }
        return module;
    }

    private static final Set<Class<? extends ConcreteService>> getConcreteServiceClassFrom(Class<?> clz, Class<? extends ConcreteService> type) {
        HashSet<Class<? extends ConcreteService>> set = new HashSet<Class<? extends ConcreteService>>();
        if (type.isAssignableFrom(clz)) {
            if (clz.isInterface() && clz.getAnnotation(Abstract.class) != null) {
                set.add(clz);
            } else {
                set.addAll(JaxRSHelper.getConcreteServiceClassFrom(clz.getSuperclass(), type));
                for (Class<?> interfaceClz : clz.getInterfaces()) {
                    set.addAll(JaxRSHelper.getConcreteServiceClassFrom(interfaceClz, type));
                }
            }
        }
        return set;
    }

    public static final Unit getUnitFromContext(DefinitionContext context) {
        Module module = JaxRSHelper.getModule(context.getDeclaringClass(), new String[0]);
        Method method = context.getDeclaringMethod();
        int count = method.getParameterTypes().length;
        for (Unit unit : (Unit[])module.getUnits()) {
            if (!method.getName().equals(unit.getMethod().getName()) || count != ((Param[])unit.getParameters()).length) continue;
            return unit;
        }
        return null;
    }

    public static Param getSubmitBody(Unit unit) {
        Param toSubmit = null;
        for (int i = 0; i < ((Param[])unit.getParameters()).length; ++i) {
            Param param = ((Param[])unit.getParameters())[i];
            if (TypeHelper.isPrimitive((Class)param.getType()) && !JaxRSHelper.postPrimitive(param)) continue;
            toSubmit = param;
            break;
        }
        return toSubmit;
    }

    public static String slash(String str) {
        if (Common.isBlank((String)str)) {
            return "";
        }
        return str.startsWith("/") ? str : "/" + str;
    }
}

