/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.struct;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.PathParam;
import org.coodex.concrete.api.MicroService;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.struct.AbstractModule;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.Predicates;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Param;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public class Unit
extends AbstractUnit<Param, Module> {
    private List<Param> pojo;
    private String name = this.getNameOnInit();

    public Unit(Method method, Module module) {
        super(method, (AbstractModule)module);
        this.validation();
    }

    private synchronized List<Param> _getPojo() {
        if (this.pojo == null) {
            this.pojo = new ArrayList<Param>();
        }
        return this.pojo;
    }

    private void validation() {
        int pojoCount = this._getPojo().size();
        String httpMethod = this.getInvokeType();
        int pojoLimited = 0;
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT") || httpMethod.equalsIgnoreCase("DELETE")) {
            pojoLimited = Integer.MAX_VALUE;
        }
        if (pojoCount > pojoLimited) {
            StringBuilder builder = new StringBuilder();
            builder.append("Object parameter count limited ").append(pojoLimited).append(" in HttpMethod.").append(httpMethod).append(", ").append(pojoCount).append(" used in ").append(this.getMethod().toGenericString());
            throw new RuntimeException(builder.toString());
        }
    }

    private String getNameOnInit() {
        List<Class> inheritedChain = ConcreteHelper.inheritedChain(this.getMethod().getDeclaringClass(), (Class)((Module)this.getDeclaringModule()).getInterfaceClass());
        if (inheritedChain == null) {
            inheritedChain = Arrays.asList(new Class[0]);
        }
        StringBuffer buffer = new StringBuffer();
        for (Class c : inheritedChain) {
            String serviceName = ConcreteHelper.getServiceName((Class)c);
            if (Common.isBlank((String)serviceName)) continue;
            buffer.append(JaxRSHelper.slash(Common.camelCase((String)serviceName, (boolean)true)));
        }
        MicroService microService = this.getMethod().getAnnotation(MicroService.class);
        buffer.append(JaxRSHelper.slash(microService == null ? Predicates.removePredicate(this.getMethod().getName()) : microService.value()));
        String toTest = JaxRSHelper.slash(((Module)this.getDeclaringModule()).getName()) + buffer.toString();
        for (Param parameter : (Param[])this.getParameters()) {
            String pathParamValue = this.getPathParam(parameter);
            if (pathParamValue == null) continue;
            String restfulNode = "{" + pathParamValue + "}";
            if (toTest != null && toTest.indexOf(restfulNode) >= 0) continue;
            buffer.append(JaxRSHelper.slash(restfulNode));
        }
        return buffer.toString();
    }

    protected String getPathParam(Param parameter) {
        PathParam pathParam1 = (PathParam)parameter.getDeclaredAnnotation(PathParam.class);
        if (pathParam1 != null) {
            return pathParam1.value();
        }
        if (JaxRSHelper.postPrimitive(parameter)) {
            return null;
        }
        Class clz = parameter.getType();
        return TypeHelper.isPrimitive((Class)clz) ? parameter.getName() : null;
    }

    public String getName() {
        return this.name;
    }

    protected Param buildParam(Method method, int index) {
        Param param = new Param(method, index);
        if (!TypeHelper.isPrimitive((Class)param.getType()) || JaxRSHelper.postPrimitive(param)) {
            this._getPojo().add(param);
            param.setPathParam(false);
        }
        return param;
    }

    public String getInvokeType() {
        return Predicates.getHttpMethod(this);
    }

    protected Param[] toArrays(List<Param> params) {
        return params.toArray(new Param[0]);
    }

    protected DefinitionContext toContext() {
        return ConcreteHelper.getContext((Method)this.getMethod(), (Class)((Module)this.getDeclaringModule()).getInterfaceClass());
    }

    public int compareTo(AbstractUnit o) {
        int v = this.getName().replaceAll("(\\{)[^{^}]{0,256}(\\})", "").compareTo(o.getName().replaceAll("(\\{)[^{^}]{0,256}(\\})", ""));
        if (v == 0) {
            v = this.getName().compareTo(o.getName());
        }
        return v == 0 ? this.getInvokeType().compareTo(o.getInvokeType()) : v;
    }

    public int getPojoCount() {
        return this._getPojo().size();
    }

    public Param[] getPojo() {
        return this._getPojo().toArray(new Param[0]);
    }
}

