/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.jaxrs.JaxRSModuleMaker;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRSHelper {
    public static final String HEADER_ERROR_OCCURRED = "CONCRETE-ERROR-OCCURRED";
    public static final String KEY_CLIENT_PROVIDER = "X-CLIENT-PROVIDER";
    private static final Logger log = LoggerFactory.getLogger(JaxRSHelper.class);
    private static final JaxRSModuleMaker JAX_RS_MODULE_MAKER = new JaxRSModuleMaker();

    public static boolean used024Behavior() {
        String style = System.getProperty("jaxrs.style.before.024");
        if (style == null) {
            style = Config.get((String)"jaxrs.style.before.024", (String[])new String[0]);
        }
        return Common.toBool((String)style, (boolean)false);
    }

    public static boolean postPrimitive(JaxrsParam param) {
        return !param.isPathParam();
    }

    @Deprecated
    public static String lowerFirstChar(String string) {
        return Common.lowerFirstChar((String)string);
    }

    @Deprecated
    public static String upperFirstChar(String string) {
        return Common.upperFirstChar((String)string);
    }

    @Deprecated
    public static String camelCase(String s) {
        return JaxRSHelper.camelCase(s, false);
    }

    @Deprecated
    public static String camelCase(String s, String delimiters) {
        return JaxRSHelper.camelCase(s, false, delimiters);
    }

    @Deprecated
    public static String camelCase(String s, boolean firstCharUpperCase) {
        return Common.camelCase((String)s, (boolean)firstCharUpperCase);
    }

    @Deprecated
    public static String camelCase(String s, boolean firstCharUpperCase, String delimiters) {
        return Common.camelCase((String)s, (boolean)firstCharUpperCase, (String)delimiters);
    }

    public static String camelCaseByPath(String s) {
        return JaxRSHelper.camelCaseByPath(s, false);
    }

    public static String camelCaseByPath(String s, boolean firstCharUpperCase) {
        StringTokenizer st = new StringTokenizer(s, "/");
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreElements()) {
            String node = st.nextToken();
            if (node.length() == 0) continue;
            builder.append('/').append(Common.camelCase((String)node, (boolean)firstCharUpperCase, (String)".-_ "));
        }
        return builder.toString();
    }

    public static final JaxrsUnit getUnitFrom(Class clz, Method method) {
        AbstractModule module = JAX_RS_MODULE_MAKER.make(clz);
        int count = method.getParameterTypes().length;
        for (JaxrsUnit unit : (JaxrsUnit[])module.getUnits()) {
            if (!method.getName().equals(unit.getMethod().getName()) || count != ((JaxrsParam[])unit.getParameters()).length) continue;
            return unit;
        }
        return null;
    }

    public static final JaxrsUnit getUnitFromContext(DefinitionContext context) {
        return JaxRSHelper.getUnitFrom(context.getDeclaringClass(), context.getDeclaringMethod());
    }

    public static JaxrsParam getSubmitBody(JaxrsUnit unit) {
        JaxrsParam toSubmit = null;
        for (int i = 0; i < ((JaxrsParam[])unit.getParameters()).length; ++i) {
            JaxrsParam param = ((JaxrsParam[])unit.getParameters())[i];
            if (TypeHelper.isPrimitive((Class)param.getType()) && !JaxRSHelper.postPrimitive(param)) continue;
            toSubmit = param;
            break;
        }
        return toSubmit;
    }

    public static String slash(String str) {
        if (Common.isBlank((String)str)) {
            return "";
        }
        return str.startsWith("/") ? str : "/" + str;
    }
}

