/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.config.Config;
import org.coodex.util.Common;

public class Predicates {
    public static final String[] HTTP_METHOD = new String[]{"PUT", "DELETE", "POST", "GET"};
    private static final String TAG_JAXRS_PREDICATES = "jaxrs.predicates";
    private static final String[] PREDICATES_PUT_DEFAULT = new String[]{"update", "set"};
    private static final String[] PREDICATES_GET_DEFAULT = new String[]{"new", "get", "findBy"};
    private static final String[] PREDICATES_DELETE_DEFAULT = new String[]{"delete"};
    private static final String[] PREDICATES_POST_DEFAULT = new String[]{"save"};
    private static final String[] PREDICATES_PUT = Config.getArray((String)"service.predicates.PUT", (String)",", (String[])PREDICATES_PUT_DEFAULT, (String[])new String[]{"jaxrs.predicates", ConcreteHelper.getAppSet()});
    private static final String[] PREDICATES_GET = Config.getArray((String)"service.predicates.GET", (String)",", (String[])PREDICATES_GET_DEFAULT, (String[])new String[]{"jaxrs.predicates", ConcreteHelper.getAppSet()});
    private static final String[] PREDICATES_DELETE = Config.getArray((String)"service.predicates.DELETE", (String)",", (String[])PREDICATES_DELETE_DEFAULT, (String[])new String[]{"jaxrs.predicates", ConcreteHelper.getAppSet()});
    private static final String[] PREDICATES_POST = Config.getArray((String)"service.predicates.POST", (String)",", (String[])PREDICATES_POST_DEFAULT, (String[])new String[]{"jaxrs.predicates", ConcreteHelper.getAppSet()});
    public static final String[][] PREDICATES = new String[][]{PREDICATES_PUT, PREDICATES_DELETE, PREDICATES_POST, PREDICATES_GET};

    public static String getHttpMethod(JaxrsUnit unit) {
        String methodName = unit.getMethod().getName();
        int methodIndex = -1;
        String lastCheck = null;
        for (int i = 0; i < PREDICATES.length; ++i) {
            for (int j = 0; j < PREDICATES[i].length; ++j) {
                int l;
                if (!methodName.startsWith(PREDICATES[i][j])) continue;
                int n = l = lastCheck == null ? 0 : lastCheck.length();
                if (PREDICATES[i][j].length() <= l) continue;
                methodIndex = i;
                lastCheck = PREDICATES[i][j];
            }
        }
        if (methodIndex >= 0) {
            return HTTP_METHOD[methodIndex];
        }
        return JaxRSHelper.getSubmitBody(unit) == null ? "GET" : "POST";
    }

    private static String[] paths(String methodName) {
        StringTokenizer st = new StringTokenizer(methodName, "/\\");
        ArrayList<String> cache = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String s = st.nextToken().trim();
            if (Common.isBlank((String)s)) continue;
            cache.add(s);
        }
        return cache.toArray(new String[0]);
    }

    private static String buildPath(String[] paths) {
        StringBuilder builder = new StringBuilder();
        for (String s : paths) {
            if (Common.isBlank((String)s)) continue;
            if (builder.length() > 0) {
                builder.append('/');
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public static final String removePredicate(String name) {
        String[][] stringArray = PREDICATES;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] predicates;
            for (String predicate : predicates = stringArray[i]) {
                if (!name.startsWith(predicate)) continue;
                return Common.lowerFirstChar((String)name.substring(predicate.length()));
            }
        }
        return name;
    }

    private static int getLastNodeIndex(String[] paths) {
        int index = -1;
        for (int i = paths.length - 1; i >= 0; --i) {
            String s = paths[i].trim();
            if (s.startsWith("{") && s.endsWith("}")) continue;
            index = i;
            break;
        }
        return index;
    }
}

