/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.logging;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.core.Level;
import org.coodex.concrete.jaxrs.logging.AbstractLogger;
import org.coodex.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.CLIENT)
@PreMatching
public class ClientLogger
extends AbstractLogger
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ClientLogger.class);

    public ClientLogger() {
        this(log);
    }

    public ClientLogger(Logger log) {
        super(log, Level.parse((String)((String)Config.getValue((String)"client", (Object)"DEBUG", (String[])new String[]{"jaxrs.logger.level", ConcreteHelper.getAppSet()}))));
    }

    public void filter(ClientRequestContext context) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Sending client request", id, context.getMethod(), context.getUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getStringHeaders());
        if (context.hasEntity() && ClientLogger.printEntity(context.getMediaType())) {
            AbstractLogger.LoggingStream stream = new AbstractLogger.LoggingStream(b, context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            context.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Client response received", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getHeaders());
        if (responseContext.hasEntity() && ClientLogger.printEntity(responseContext.getMediaType())) {
            responseContext.setEntityStream(this.logInboundEntity(b, responseContext.getEntityStream(), ClientLogger.getCharset(responseContext.getMediaType())));
        }
        this.log(b);
    }
}

