/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.logging;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.core.Level;
import org.coodex.concrete.jaxrs.logging.AbstractLogger;
import org.coodex.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
public class ServerLogger
extends AbstractLogger
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ServerLogger.class);

    public ServerLogger() {
        super(log, Level.parse((String)((String)Config.getValue((String)"server", (Object)"NONE", (String[])new String[]{"jaxrs.logger.level", ConcreteHelper.getAppSet()}))));
    }

    public void filter(ContainerRequestContext context) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getHeaders());
        if (context.hasEntity() && ServerLogger.printEntity(context.getMediaType())) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), ServerLogger.getCharset(context.getMediaType())));
        }
        this.log(b);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getStringHeaders());
        if (responseContext.hasEntity() && ServerLogger.printEntity(responseContext.getMediaType())) {
            AbstractLogger.LoggingStream stream = new AbstractLogger.LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }
}

