/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.struct;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.AbstractUnit;
import org.coodex.concrete.jaxrs.Body;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.Predicates;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public class JaxrsUnit
extends AbstractUnit<JaxrsParam, JaxrsModule> {
    private List<JaxrsParam> pojo;
    private String name = this.getNameOnInit();
    private String declaredName = null;

    public JaxrsUnit(Method method, JaxrsModule module) {
        super(method, (AbstractModule)module);
        this.validation();
    }

    private synchronized List<JaxrsParam> _getPojo() {
        if (this.pojo == null) {
            this.pojo = new ArrayList<JaxrsParam>();
        }
        return this.pojo;
    }

    private void validation() {
        int pojoCount = this._getPojo().size();
        String httpMethod = this.getInvokeType();
        int pojoLimited = 0;
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT") || httpMethod.equalsIgnoreCase("DELETE")) {
            pojoLimited = Integer.MAX_VALUE;
        }
        if (pojoCount > pojoLimited) {
            String builder = "Object parameter count limited " + pojoLimited + " in HttpMethod." + httpMethod + ", " + pojoCount + " used in " + this.getMethod().toGenericString();
            throw new RuntimeException(builder);
        }
    }

    private String getDeclaredName() {
        if (this.declaredName == null) {
            this.declaredName = this.getUnitDeclaredName();
        }
        return this.declaredName;
    }

    private String getNameOnInit() {
        if (JaxRSHelper.used024Behavior()) {
            StringBuilder unitName = new StringBuilder(this.getDeclaredName());
            String toTest = JaxRSHelper.slash(((JaxrsModule)this.getDeclaringModule()).getName()) + this.getDeclaredName();
            for (JaxrsParam parameter : (JaxrsParam[])this.getParameters()) {
                String restfulNode;
                String pathParamValue = this.getPathParam(parameter);
                if (pathParamValue == null || toTest.contains(restfulNode = "{" + pathParamValue + "}")) continue;
                unitName.append(JaxRSHelper.slash(restfulNode));
            }
            return unitName.toString();
        }
        return this.getDeclaredName();
    }

    private String getUnitDeclaredName() {
        List<Class> inheritedChain = ConcreteHelper.inheritedChain(this.getMethod().getDeclaringClass(), (Class)((JaxrsModule)this.getDeclaringModule()).getInterfaceClass());
        if (inheritedChain == null) {
            inheritedChain = Collections.emptyList();
        }
        StringBuilder buffer = new StringBuilder();
        for (Class c : inheritedChain) {
            String serviceName = ConcreteHelper.getServiceName((Class)c);
            if (Common.isBlank((String)serviceName)) continue;
            buffer.append(JaxRSHelper.slash(Common.camelCase((String)serviceName, (boolean)true)));
        }
        ConcreteService concreteService = this.getMethod().getAnnotation(ConcreteService.class);
        buffer.append(JaxRSHelper.slash(concreteService == null ? Predicates.removePredicate(this.getMethod().getName()) : concreteService.value()));
        return buffer.toString();
    }

    private String getPathParam(JaxrsParam parameter) {
        if (JaxRSHelper.postPrimitive(parameter)) {
            return null;
        }
        Class clz = parameter.getType();
        return TypeHelper.isPrimitive((Class)clz) ? parameter.getName() : null;
    }

    public String getName() {
        return this.name;
    }

    private void addToBody(JaxrsParam param) {
        param.setPathParam(false);
        this._getPojo().add(param);
    }

    private boolean isBodyPrimitive(JaxrsParam param) {
        if (JaxRSHelper.used024Behavior()) {
            return param.getDeclaredAnnotation(Body.class) != null;
        }
        return this.getDeclaredName().indexOf(String.format("{%s}", param.getName())) < 0;
    }

    protected JaxrsParam buildParam(Method method, int index) {
        JaxrsParam param = new JaxrsParam(method, index);
        if (!TypeHelper.isPrimitive((Class)param.getType()) || this.isBodyPrimitive(param)) {
            this.addToBody(param);
        }
        return param;
    }

    public String getInvokeType() {
        return Predicates.getHttpMethod(this);
    }

    protected JaxrsParam[] toArrays(List<JaxrsParam> params) {
        return params.toArray(new JaxrsParam[0]);
    }

    protected DefinitionContext toContext() {
        return ConcreteHelper.getContext((Method)this.getMethod(), (Class)((JaxrsModule)this.getDeclaringModule()).getInterfaceClass());
    }

    public int compareTo(AbstractUnit o) {
        int v = this.getName().replaceAll("(\\{)[^{^}]{0,256}(\\})", "").compareTo(o.getName().replaceAll("(\\{)[^{^}]{0,256}(\\})", ""));
        if (v == 0) {
            v = this.getName().compareTo(o.getName());
        }
        return v == 0 ? this.getInvokeType().compareTo(o.getInvokeType()) : v;
    }

    public int getPojoCount() {
        return this._getPojo().size();
    }

    public JaxrsParam[] getPojo() {
        return this._getPojo().toArray(new JaxrsParam[0]);
    }
}

