/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.swagger;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;
import org.coodex.concrete.jaxrs.struct.JaxrsParam;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.config.Config;
import org.coodex.mock.Mocker;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;

public class SwaggerHelper {
    private static ThreadLocal<Map<String, Schema>> definitions = new ThreadLocal();
    private static ThreadLocal<Set<String>> readyForSchema = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenAPI toOpenAPI(String url, List<Class> classes) {
        readyForSchema.remove();
        OpenAPI openAPI = new OpenAPI().info(new Info().title((String)Config.getValue((String)"swagger.title", (Object)"concrete-swagger", (String[])new String[]{"concrete", "swagger"})).description((String)Config.getValue((String)"swagger.description", (Object)"Thanks for choosing concrete", (String[])new String[]{"concrete", "swagger"})).version((String)Config.getValue((String)"swagger.version", (Object)"1.0.0", (String[])new String[]{"concrete", "swagger"})).contact(new Contact().name((String)Config.getValue((String)"swagger.contact.name", (Object)"concrete", (String[])new String[]{"concrete", "swagger"})).url((String)Config.getValue((String)"swagger.contact.url", (Object)"https://concrete.coodex.org", (String[])new String[]{"concrete", "swagger"})))).addServersItem(new Server().url(url)).paths(new Paths());
        LinkedHashSet<Tag> tags = new LinkedHashSet<Tag>();
        definitions.set(new LinkedHashMap());
        try {
            for (Class clz : classes) {
                JaxrsModule module = new JaxrsModule(clz);
                tags.add(new Tag().name(module.getLabel()).description(module.getDescription()));
                for (JaxrsUnit unit : (JaxrsUnit[])module.getUnits()) {
                    String name = ((JaxrsModule)unit.getDeclaringModule()).getName() + unit.getName();
                    openAPI.path(name, SwaggerHelper.toPathItem(unit, (PathItem)openAPI.getPaths().get((Object)name)));
                }
            }
            openAPI.tags(new ArrayList(tags));
            Components components = new Components();
            Map<String, Schema> defined = definitions.get();
            for (Map.Entry<String, Schema> entry : defined.entrySet()) {
                components.addSchemas(entry.getKey(), entry.getValue());
            }
            openAPI.components(components);
        }
        finally {
            definitions.remove();
        }
        return openAPI;
    }

    private static PathItem toPathItem(JaxrsUnit unit, PathItem item) {
        if (item == null) {
            item = new PathItem();
        }
        Operation operation = new Operation();
        operation.setSummary(unit.getLabel());
        operation.setDescription(unit.getDescription());
        operation.addTagsItem(((JaxrsModule)unit.getDeclaringModule()).getLabel());
        if (unit.getAccessAllow() != null) {
            Parameter parameter = new Parameter().name("concrete-token-id").in("header").required(Boolean.valueOf(true)).allowEmptyValue(Boolean.valueOf(false)).description("Concrete Token").schema(SwaggerHelper.schema(String.class));
            operation.addParametersItem(parameter);
        }
        for (JaxrsParam param : (Parameter)unit.getParameters()) {
            if (!param.isPathParam()) continue;
            Parameter parameter = new Parameter();
            parameter.name(param.getName()).in(param.isPathParam() ? "path" : "body").description(param.getDescription()).required(Boolean.valueOf(true)).allowEmptyValue(Boolean.valueOf(false)).schema(SwaggerHelper.schema(GenericTypeHelper.toReference((Type)param.getGenericType(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass()))).addExample("default", new Example().value(Mocker.mockParameter((Method)unit.getMethod(), (int)param.getIndex(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass())));
            operation.addParametersItem(parameter);
        }
        if (!"get".equalsIgnoreCase(unit.getInvokeType()) || unit.getPojoCount() != 0) {
            RequestBody body = new RequestBody();
            Content content = new Content();
            MediaType mediaType = new MediaType();
            if (unit.getPojoCount() == 1) {
                JaxrsParam param;
                param = unit.getPojo()[0];
                mediaType.schema(SwaggerHelper.schema(GenericTypeHelper.toReference((Type)param.getGenericType(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass())).title(param.getLabel()).description(param.getDescription())).addExamples("default", new Example().value(Mocker.mockParameter((Method)unit.getMethod(), (int)param.getIndex(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass())));
            } else {
                HashMap<String, Object> mocked = new HashMap<String, Object>();
                Schema objectSchema = new Schema();
                for (JaxrsParam param : unit.getPojo()) {
                    objectSchema.addProperties(param.getName(), SwaggerHelper.schema(GenericTypeHelper.toReference((Type)param.getGenericType(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass())).title(param.getLabel()).description(param.getDescription()));
                    mocked.put(param.getName(), Mocker.mockParameter((Method)unit.getMethod(), (int)param.getIndex(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass()));
                }
                objectSchema.example(mocked);
                mediaType.schema(objectSchema).addExamples("default", new Example().value(mocked));
            }
            content.addMediaType("application/json", mediaType);
            body.content(content);
            operation.requestBody(body);
        }
        operation.responses(new ApiResponses().addApiResponse("200", new ApiResponse().content(new Content().addMediaType("application/json", new MediaType().schema(SwaggerHelper.schema(GenericTypeHelper.toReference((Type)unit.getGenericReturnType(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass()))).example(Mocker.mockMethod((Method)unit.getMethod(), (Type)((JaxrsModule)unit.getDeclaringModule()).getInterfaceClass()))))).addApiResponse("204", new ApiResponse()).addApiResponse("default", new ApiResponse().content(new Content().addMediaType("application/json", new MediaType().schema(SwaggerHelper.schema(ErrorInfo.class))))));
        switch (unit.getInvokeType().toLowerCase()) {
            case "get": {
                item.get(operation);
                break;
            }
            case "post": {
                item.post(operation);
                break;
            }
            case "put": {
                item.put(operation);
                break;
            }
            case "delete": {
                item.delete(operation);
            }
        }
        return item;
    }

    private static Schema schema(Type type) {
        if (type instanceof Class) {
            return SwaggerHelper.classSchema((Class)type);
        }
        if (type instanceof ParameterizedType) {
            Class c = (Class)((ParameterizedType)type).getRawType();
            if (Collection.class.isAssignableFrom(c)) {
                Type t = GenericTypeHelper.solveFromType(Collection.class.getTypeParameters()[0], (Type)type);
                if (Byte.TYPE.equals(t)) {
                    return new ByteArraySchema();
                }
                return new ArraySchema().items(SwaggerHelper.schema(t));
            }
            if (!Map.class.isAssignableFrom(c)) {
                return SwaggerHelper.pojoSchema(type);
            }
        } else if (type instanceof GenericArrayType) {
            return new ArraySchema().items(SwaggerHelper.schema(((GenericArrayType)type).getGenericComponentType()));
        }
        return new Schema();
    }

    private static Schema classSchema(Class c) {
        if (byte[].class.equals((Object)c)) {
            return new ByteArraySchema();
        }
        if (c.isArray()) {
            return new ArraySchema().items(SwaggerHelper.classSchema(c.getComponentType()));
        }
        if (Void.TYPE.equals(c) || Void.class.equals((Object)c)) {
            return new ObjectSchema();
        }
        if (Byte.class.equals((Object)c) || Integer.TYPE.equals(c) || Integer.class.equals((Object)c) || Short.TYPE.equals(c) || Short.class.equals((Object)c)) {
            return new IntegerSchema();
        }
        if (Long.TYPE.equals(c) || Long.class.equals((Object)c)) {
            return new IntegerSchema().format("int64");
        }
        if (Float.TYPE.equals(c) || Float.class.equals((Object)c)) {
            return new NumberSchema().format("float");
        }
        if (Double.TYPE.equals(c) || Double.class.equals((Object)c)) {
            return new NumberSchema().format("double");
        }
        if (Character.TYPE.equals(c) || Character.class.equals((Object)c) || String.class.equals((Object)c)) {
            return new StringSchema();
        }
        if (Date.class.equals((Object)c) || Calendar.class.equals((Object)c)) {
            return new DateTimeSchema();
        }
        return SwaggerHelper.pojoSchema(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema pojoSchema(Type t) {
        String name;
        block9: {
            Map<String, Schema> defined = definitions.get();
            if (!defined.containsKey(name = t.toString().replace(' ', '_'))) {
                boolean remove;
                Set<String> set = readyForSchema.get();
                boolean bl = remove = set == null;
                if (set == null) {
                    set = new LinkedHashSet<String>();
                    readyForSchema.set(set);
                }
                try {
                    if (!set.contains(name)) {
                        set.add(name);
                        Schema objectSchema = new Schema();
                        PojoInfo pojoInfo = new PojoInfo(t);
                        for (PojoProperty property : pojoInfo.getProperties()) {
                            Schema schema = SwaggerHelper.schema(property.getType());
                            Description description = (Description)property.getAnnotation(Description.class);
                            if (description != null) {
                                schema.title(description.name()).description(description.description());
                            }
                            objectSchema.addProperties(property.getName(), schema);
                        }
                        defined.put(name, objectSchema);
                        break block9;
                    }
                    Schema schema = new Schema().title("cycle ref").description(name);
                    return schema;
                }
                finally {
                    if (remove) {
                        set.remove(name);
                    }
                }
            }
        }
        return new Schema().$ref("#/components/schemas/" + name);
    }

    public static String toJson(String url, List<Class> classes) {
        return Json.pretty((Object)SwaggerHelper.toOpenAPI(url, classes));
    }

    public static String toYaml(String url, List<Class> classes) {
        return Yaml.pretty((Object)SwaggerHelper.toOpenAPI(url, classes));
    }
}

