/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.rx;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractInvoker;
import org.coodex.concrete.client.rx.RXMethodInvocation;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.rx.ReactiveExtensionFor;
import org.coodex.concurrent.ExecutorsHelper;

public abstract class AbstractRxInvoker
extends AbstractInvoker {
    private static ExecutorService executorService;

    public AbstractRxInvoker(Destination destination) {
        super(destination);
    }

    protected static Method findTargetMethod(Class targetClass, Method method) {
        Method targetMethod = null;
        for (Method m : targetClass.getMethods()) {
            if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getParameterTypes(), method.getParameterTypes())) continue;
            targetMethod = m;
            break;
        }
        if (targetMethod == null) {
            throw new RuntimeException("Reactive method not found for " + targetClass.getName() + " " + method.getName());
        }
        return targetMethod;
    }

    public static RuntimeContext getRuntimeContext(Class rxClass, Method method) {
        Class targetClass = rxClass.getAnnotation(ReactiveExtensionFor.class).value();
        Method targetMethod = AbstractRxInvoker.findTargetMethod(targetClass, method);
        return RuntimeContext.getRuntimeContext((Method)targetMethod, (Class)targetClass);
    }

    protected static Object buildSyncInstance(Class targetClass) throws IllegalAccessException, InvocationTargetException {
        return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy1, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Object.class)) {
                    return method.invoke(proxy1, args);
                }
                throw new RuntimeException("method " + method.getName() + " not implement.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ExecutorService getExecutorService() {
        if (executorService != null) return executorService;
        Class<AbstractRxInvoker> clazz = AbstractRxInvoker.class;
        synchronized (AbstractRxInvoker.class) {
            if (executorService != null) return executorService;
            executorService = ExecutorsHelper.newLinkedThreadPool((int)ConcreteHelper.getProfile().getInt("client.executor.corePoolSize", 0), (int)ConcreteHelper.getProfile().getInt("client.executor.maximumPoolSize", Integer.MAX_VALUE), (long)ConcreteHelper.getProfile().getInt("client.executor.keepAliveTime", 60));
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    protected abstract Observable invoke(RuntimeContext var1, Object ... var2);

    public final Object invoke(Object instance, Class clz, Method method, Object ... args) throws Throwable {
        return this.invokerWithAop(AbstractRxInvoker.getRuntimeContext(clz, method), args);
    }

    Observable invokerWithAop(final RuntimeContext runtimeContext, final Object[] args) throws InvocationTargetException, IllegalAccessException {
        final ServiceContext serviceContext = this.buildContext(runtimeContext.getDeclaringClass(), runtimeContext.getDeclaringMethod());
        final RXMethodInvocation invocation = new RXMethodInvocation(runtimeContext, args);
        ConcreteContext.runWithContext((ServiceContext)serviceContext, (CallableClosure)new CallableClosure(){

            public Object call() throws Throwable {
                ClientHelper.getAsyncInterceptorChain().before(runtimeContext, invocation);
                return null;
            }
        });
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

            public void subscribe(final ObservableEmitter emitter) throws Exception {
                ConcreteContext.runWithContext((ServiceContext)serviceContext, (CallableClosure)new CallableClosure(){

                    public Object call() throws Throwable {
                        AbstractRxInvoker.this.invoke(runtimeContext, args).subscribe(new Observer(){

                            public void onSubscribe(Disposable d) {
                            }

                            public void onNext(final Object o) {
                                ConcreteContext.runWithContext((ServiceContext)serviceContext, (CallableClosure)new CallableClosure(){

                                    public Object call() throws Throwable {
                                        ClientHelper.getAsyncInterceptorChain().after(runtimeContext, invocation, o);
                                        emitter.onNext(o);
                                        return null;
                                    }
                                });
                            }

                            public void onError(Throwable e) {
                                emitter.onError(e);
                            }

                            public void onComplete() {
                                emitter.onComplete();
                            }
                        });
                        return null;
                    }
                });
            }
        });
    }
}

