/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.boot;

import org.coodex.concrete.amqp.AMQPConnectionConfig;
import org.coodex.concrete.spring.AbstractRuntimeParameter;
import org.coodex.util.Common;
import org.springframework.core.annotation.AnnotationAttributes;

public class AMQPRuntime
extends AbstractRuntimeParameter {
    private final AMQPConnectionConfig config;
    private String exchangeName;
    private String queueName;
    private long ttl;

    public AMQPRuntime() {
        this(new AMQPConnectionConfig(), null, null, null, null, -1L);
    }

    public AMQPRuntime(AMQPConnectionConfig config, String[] servicePackages, Class[] classes, String exchangeName, String queueName, long ttl) {
        super(servicePackages, classes);
        this.config = config;
        this.exchangeName = exchangeName;
        this.queueName = queueName;
        this.ttl = ttl;
        this.cleanConfig();
    }

    private void cleanConfig() {
        if (Common.isBlank((String)this.config.getUri())) {
            this.config.setUri((String)this.get("location", ""));
        }
        if (Common.isBlank((String)this.config.getHost())) {
            this.config.setHost((String)this.get("host", ""));
        }
        if (Common.isBlank((String)this.config.getPassword())) {
            this.config.setPassword((String)this.get("password", ""));
        }
        if (Common.isBlank((String)this.config.getUsername())) {
            this.config.setUsername((String)this.get("username", ""));
        }
        if (Common.isBlank((String)this.config.getVirtualHost())) {
            this.config.setVirtualHost((String)this.get("virtualHost", ""));
        }
        if (Common.isBlank((String)this.config.getSharedExecutorName())) {
            this.config.setSharedExecutorName((String)this.get("executorName", ""));
        }
        if (this.config.getPort() != null && this.config.getPort() <= 0) {
            this.config.setPort((Integer)this.get("port", null));
        }
    }

    public AMQPConnectionConfig getConfig() {
        return this.config;
    }

    public String getExchangeName() {
        return Common.isBlank((String)this.exchangeName) ? (String)this.get("exchangeName", null) : this.exchangeName;
    }

    public String getQueueName() {
        return Common.isBlank((String)this.queueName) ? (String)this.get("queueName", null) : this.queueName;
    }

    public long getTtl() {
        return this.ttl <= 0L ? (Long)this.get("ttl", 60000L) : this.ttl;
    }

    protected String getNamespace() {
        return "amqp";
    }

    protected void loadCustomRuntimeConfigFrom(AnnotationAttributes annotationAttributes) {
        this.config.setUri(annotationAttributes.getString("location"));
        this.config.setPort((Integer)annotationAttributes.getNumber("port"));
        this.config.setVirtualHost(annotationAttributes.getString("virtualHost"));
        this.config.setUsername(annotationAttributes.getString("username"));
        this.config.setPassword(annotationAttributes.getString("password"));
        this.config.setHost(annotationAttributes.getString("host"));
        this.config.setSharedExecutorName(annotationAttributes.getString("executorName"));
        this.exchangeName = annotationAttributes.getString("exchangeName");
        this.queueName = annotationAttributes.getString("queueName");
        this.ttl = (Long)annotationAttributes.getNumber("ttl");
        this.cleanConfig();
    }
}

