/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.amqp.AMQPConnectionConfig;
import org.coodex.concrete.amqp.AMQPConnectionFacade;
import org.coodex.concrete.amqp.AMQPHelper;
import org.coodex.concrete.amqp.AMQPModule;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.ThrowableMapperFacade;
import org.coodex.concrete.core.Level;
import org.coodex.concrete.own.OwnServiceProvider;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.concrete.own.ResponsePackage;
import org.coodex.concrete.support.amqp.AMQPCaller;
import org.coodex.concrete.support.amqp.AMQPServiceContext;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPApplication
extends OwnServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(AMQPApplication.class);
    private static OwnServiceProvider.OwnModuleBuilder AMQP_MODULE_BUILDER = AMQPModule::new;
    private final String exchangeName;
    private Channel channel;
    private final Level level;

    public AMQPApplication(AMQPConnectionConfig config) {
        this(config, null, null, null);
    }

    public AMQPApplication(AMQPConnectionConfig config, String exchangeName, String queueName, Long ttl) {
        this.exchangeName = AMQPHelper.getExchangeName((String)exchangeName);
        this.connect(config, queueName, ttl);
        this.level = Level.parse((String)((String)Config.getValue((String)"server", (Object)"NONE", (String[])new String[]{"amqp.logger.level", ConcreteHelper.getAppSet()})));
    }

    protected OwnServiceProvider.OwnModuleBuilder getModuleBuilder() {
        return AMQP_MODULE_BUILDER;
    }

    protected ServerSideContext getServerSideContext(RequestPackage<Object> requestPackage, String tokenId, Caller caller) {
        Subjoin subjoin = this.getSubjoin(requestPackage);
        return new AMQPServiceContext(caller, subjoin, this.getLocale(subjoin), tokenId);
    }

    protected String getModuleName() {
        return "amqp";
    }

    private Map<String, Object> getQueueArguments(Long ttl) {
        if (ttl != null && ttl > 0L) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("x-message-ttl", ttl);
            return args;
        }
        return null;
    }

    private void connect(AMQPConnectionConfig config, String queueName, Long ttl) {
        try {
            final JSONSerializer serializer = JSONSerializerFactory.getInstance();
            if (serializer == null) {
                throw new RuntimeException("none json serializer found.");
            }
            Connection connection = AMQPConnectionFacade.getConnection((AMQPConnectionConfig)config);
            this.channel = connection.createChannel();
            this.channel.exchangeDeclare(this.exchangeName, BuiltinExchangeType.TOPIC);
            String queue = queueName;
            if (Common.isBlank((String)queue)) {
                queue = this.channel.queueDeclare().getQueue();
            } else {
                this.channel.queueDeclare(queue, true, false, false, this.getQueueArguments(ttl));
            }
            this.channel.queueBind(queue, this.exchangeName, "request.*");
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                private void send(String json, String clientId) throws IOException {
                    if (AMQPApplication.this.level.isEnabled(log)) {
                        AMQPApplication.this.level.log(log, "send to " + clientId + ": " + json);
                    }
                    AMQPApplication.this.channel.basicPublish(AMQPApplication.this.exchangeName, "response." + clientId, null, json.getBytes(StandardCharsets.UTF_8));
                }

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                    final String clientId = envelope.getRoutingKey().substring("request.".length());
                    String bodyStr = new String(body, StandardCharsets.UTF_8);
                    if (AMQPApplication.this.level.isEnabled(log)) {
                        AMQPApplication.this.level.log(log, "message received: " + bodyStr);
                    }
                    RequestPackage requestPackage = (RequestPackage)serializer.parse(bodyStr, new GenericTypeHelper.GenericType<RequestPackage<Object>>(){}.getType());
                    AMQPApplication.this.invokeService(requestPackage, new AMQPCaller(AMQPApplication.this.getSubjoin(requestPackage)), (OwnServiceProvider.ResponseVisitor)new OwnServiceProvider.DefaultResponseVisitor(){

                        public void visit(String json) {
                            try {
                                this.send(json, clientId);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, (msgId, th) -> {
                        ResponsePackage responsePackage = new ResponsePackage();
                        responsePackage.setOk(false);
                        responsePackage.setMsgId(msgId);
                        responsePackage.setContent((Object)ThrowableMapperFacade.toErrorInfo((Throwable)th));
                        try {
                            this.send(serializer.toJson((Object)responsePackage), clientId);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }, (serverSideMessage, tokenId) -> {}, null);
                }
            });
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    protected void finalize() throws Throwable {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.channel = null;
        }
    }

    public String getNamespace() {
        return "amqp";
    }
}

