/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.dubbo;

import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.coodex.concrete.dubbo.DubboConfigCaching;
import org.coodex.concrete.support.dubbo.AbstractDubboApplication;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public class ApacheDubboApplication
extends AbstractDubboApplication {
    private static Singleton<RegistryConfig> simpleRegistry = new Singleton((Singleton.Builder)new Singleton.Builder<RegistryConfig>(){

        public RegistryConfig build() {
            ServiceConfig config = new ServiceConfig();
            config.setApplication(DubboConfigCaching.getApplicationConfig((String)"simple-registry"));
            ProtocolConfig protocolConfig = new ProtocolConfig();
            protocolConfig.setPort(Integer.valueOf(9090));
            config.setProtocol(protocolConfig);
            return DubboConfigCaching.getSimpleRegistry();
        }
    });
    private final List<RegistryConfig> registryConfigs;
    private final List<ProtocolConfig> protocolConfigs;
    private final String version;

    public ApacheDubboApplication(String applicationName, Set<String> registries, Set<String> protocols, String version) {
        super(applicationName);
        this.registryConfigs = DubboConfigCaching.getRegistries(registries);
        if (this.registryConfigs.size() == 0) {
            this.registryConfigs.add((RegistryConfig)simpleRegistry.get());
        }
        this.protocolConfigs = DubboConfigCaching.getProtocols(protocols);
        if (this.protocolConfigs.size() == 0) {
            this.protocolConfigs.add(DubboConfigCaching.getProtocol((String)"dubbo"));
        }
        this.version = version;
    }

    public ApacheDubboApplication(String applicationName, String[] registries, String[] protocols, String version) {
        this(applicationName, Common.arrayToSet((Object[])registries), Common.arrayToSet((Object[])protocols), version);
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    @Override
    protected List<RegistryConfig> getRegistries() {
        return this.registryConfigs;
    }

    @Override
    protected List<ProtocolConfig> getProtocols() {
        return this.protocolConfigs;
    }
}

