/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.dubbo;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Locale;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.coodex.concrete.api.Application;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.dubbo.ApacheDubboSubjoin;
import org.coodex.concrete.dubbo.DubboConfigCaching;
import org.coodex.concrete.support.dubbo.ApacheDubboCaller;
import org.coodex.concrete.support.dubbo.ApacheDubboServerSideServiceContext;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDubboApplication
implements Application {
    private static final Logger log = LoggerFactory.getLogger(AbstractDubboApplication.class);
    private final String applicationName;
    private Singleton<String> version = new Singleton(this::getVersion);

    public AbstractDubboApplication(String applicationName) {
        this.applicationName = applicationName;
    }

    private static Locale getLocale(String localeStr) {
        try {
            return Common.isBlank((String)localeStr) ? null : Locale.forLanguageTag(localeStr);
        }
        catch (Throwable th) {
            log.warn("invalid locale string: {}", (Object)localeStr);
            return null;
        }
    }

    public void registerPackage(String ... packages) {
        if (packages == null || packages.length == 0) {
            ConcreteHelper.foreachClassInPackages(this::registerClass, (String[])ConcreteHelper.getApiPackages((String)this.getNamespace()));
        } else {
            ConcreteHelper.foreachClassInPackages(this::registerClass, (String[])packages);
        }
    }

    public void register(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return;
        }
        for (Class<?> clz : classes) {
            this.registerClass(clz);
        }
    }

    private void registerClass(Class<?> clz) {
        if (ConcreteHelper.isConcreteService(clz)) {
            this.registerConcreteService(clz);
        }
    }

    protected abstract String getVersion();

    private void registerConcreteService(Class<?> clz) {
        Singleton serviceImpl = new Singleton(() -> BeanServiceLoaderProvider.getBeanProvider().getBean(clz));
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setApplication(DubboConfigCaching.getApplicationConfig((String)this.applicationName));
        serviceConfig.setRegistries(this.getRegistries());
        serviceConfig.setProtocols(this.getProtocols());
        serviceConfig.setInterface(clz);
        serviceConfig.setVersion(DubboConfigCaching.getServiceVersion((String)((String)this.version.get())));
        serviceConfig.setRef(Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (proxy, method, args) -> {
            RpcContext context = RpcContext.getContext();
            Subjoin subjoin = new ApacheDubboSubjoin(context.getAttachments()).wrap();
            ApacheDubboCaller caller = new ApacheDubboCaller(context);
            String tokenId = subjoin.get("CONCRETE-TOKEN-ID");
            Trace trace = APM.build((Subjoin)subjoin).tag("remote", caller.getAddress()).tag("agent", caller.getClientProvider()).start(String.format("apache-dubbo: %s.%s", method.getDeclaringClass().getName(), method.getName()));
            try {
                ApacheDubboServerSideServiceContext serverSideContext = new ApacheDubboServerSideServiceContext(new ApacheDubboCaller(context), subjoin, AbstractDubboApplication.getLocale(subjoin.get("locale")), tokenId);
                Object result = ConcreteContext.runServiceWithContext((ServiceContext)serverSideContext, () -> args == null || args.length == 0 ? method.invoke(serviceImpl.get(), new Object[0]) : method.invoke(serviceImpl.get(), args), (Class)clz, (Method)method, (Object[])args);
                try {
                    String newTokenId = serverSideContext.getTokenId();
                    if (!Common.isBlank((String)newTokenId) && !Common.isSameStr((String)newTokenId, (String)tokenId)) {
                        subjoin.add("CONCRETE-TOKEN-ID", newTokenId);
                    }
                }
                catch (Throwable th) {
                    log.warn("token error?? {}", (Object)th.getLocalizedMessage(), (Object)th);
                }
                context.setAttachments(ConcreteHelper.updatedMap((Subjoin)subjoin));
                Object object = result;
                return object;
            }
            catch (Throwable th) {
                context.setAttachments(ConcreteHelper.updatedMap((Subjoin)subjoin));
                trace.error(th);
                throw th;
            }
            finally {
                trace.finish();
            }
        }));
        serviceConfig.export();
    }

    public String getNamespace() {
        return "dubbo";
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    protected abstract List<RegistryConfig> getRegistries();

    protected abstract List<ProtocolConfig> getProtocols();
}

