/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.dubbo;

import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.alibaba.dubbo.rpc.RpcContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.api.Application;
import org.coodex.concrete.common.AModule;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.SubjoinBaseJava7;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.dubbo.DubboHelper;
import org.coodex.concrete.dubbo.ProxyFor;
import org.coodex.concrete.support.dubbo.DubboServiceContext;
import org.coodex.util.Common;
import org.coodex.util.GenericType;
import org.coodex.util.ReflectHelper;
import org.coodex.util.SingletonMap;
import org.springframework.cglib.proxy.InvocationHandler;
import org.springframework.cglib.proxy.Proxy;

public class DubboApplication
implements Application {
    private static final InvokerBuilder invokerBuilder = new InvokerBuilder();
    private static SingletonMap<Integer, ProtocolConfig> protocals = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<Integer, ProtocolConfig>(){

        public ProtocolConfig build(Integer key) {
            ProtocolConfig protocolConfig = new ProtocolConfig();
            protocolConfig.setPort(Integer.valueOf(key));
            protocolConfig.setHost("0.0.0.0");
            return protocolConfig;
        }
    });
    private final String name;
    private final List<RegistryConfig> registryConfig;
    private final int[] ports;
    private Set<Class<?>> registered = new ConcurrentHashSet();

    public DubboApplication(String name, List<RegistryConfig> registryConfig, int ... ports) {
        int[] nArray;
        this.name = name;
        if (ports == null || ports.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = this.ports = ports;
        }
        if (registryConfig == null || registryConfig.size() == 0) {
            throw new RuntimeException("no registry for " + name);
        }
        this.registryConfig = registryConfig;
    }

    private static String objectToStr(Object o) {
        return JSONSerializerFactory.getInstance().toJson(o);
    }

    public void registerPackage(String ... packages) {
        ConcreteHelper.foreachService((ReflectHelper.Processor)new ReflectHelper.Processor(){

            public void process(Class<?> serviceClass) {
                DubboApplication.this.registerClass(serviceClass);
            }
        }, (String[])packages);
    }

    public void register(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.registerClass(clz);
        }
    }

    private void registerClass(Class<?> concreteClass) {
        IF.not((boolean)ConcreteHelper.isConcreteService(concreteClass), (String)(concreteClass + " NOT concrete service."));
        concreteClass = DubboHelper.getDubboInterface(concreteClass);
        if (!this.registered.contains(concreteClass)) {
            ServiceConfig serviceConfig = new ServiceConfig();
            serviceConfig.setApplication((ApplicationConfig)DubboHelper.applications.getInstance((Object)this.name));
            serviceConfig.setRegistries(this.registryConfig);
            ArrayList<Object> protocolConfigs = new ArrayList<Object>();
            for (int port : this.ports) {
                protocolConfigs.add(protocals.getInstance((Object)port));
            }
            serviceConfig.setProtocols(protocolConfigs);
            serviceConfig.setInterface(concreteClass);
            serviceConfig.setRef(invokerBuilder.build(concreteClass));
            serviceConfig.export();
            this.registered.add(concreteClass);
        }
    }

    private static class InvokerBuilder
    implements SingletonMap.Builder<Class, Object> {
        private InvokerBuilder() {
        }

        public Object build(Class key) {
            return this.buildConcreteServiceImpl(key);
        }

        private Object buildConcreteServiceImpl(Class dpClass) {
            final Class concreteClass = dpClass.getAnnotation(ProxyFor.class).value();
            return Proxy.newProxyInstance((ClassLoader)DubboApplication.class.getClassLoader(), (Class[])new Class[]{dpClass}, (InvocationHandler)new InvocationHandler(){

                private Method findActualMethod(Method methodOfProxy) throws NoSuchMethodException {
                    return methodOfProxy.getParameterTypes().length == 0 ? concreteClass.getMethod(methodOfProxy.getName(), new Class[0]) : concreteClass.getMethod(methodOfProxy.getName(), methodOfProxy.getParameterTypes());
                }

                public Object invoke(Object o, Method method, final Object[] objects) throws Throwable {
                    Token token;
                    if (method.getDeclaringClass().equals(Object.class)) {
                        return method.invoke((Object)this, objects);
                    }
                    final Method m = this.findActualMethod(method);
                    String clientIP = RpcContext.getContext().getRemoteHost();
                    Map map = (Map)JSONSerializerFactory.getInstance().parse(RpcContext.getContext().getAttachment("subjoin"), new GenericType<Map<String, String>>(){}.genericType());
                    SubjoinBaseJava7 subjoin = new SubjoinBaseJava7(map);
                    String tokenId = RpcContext.getContext().getAttachment("CONCRETE-TOKEN-ID");
                    String agent = RpcContext.getContext().getAttachment("user-agent");
                    RpcContext.getContext().removeAttachment("CONCRETE-TOKEN-ID").removeAttachment("user-agent").removeAttachment("subjoin");
                    TokenManager tokenManager = (TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class);
                    Token token2 = token = Common.isBlank((String)tokenId) ? null : tokenManager.getToken(tokenId, false);
                    if (token == null || !token.isValid()) {
                        token = tokenManager.getToken(Common.getUUIDStr(), true);
                    }
                    Object result = ConcreteContext.runWithContext((ServiceContext)new DubboServiceContext(new DubboCaller(clientIP, agent), (AbstractUnit)AModule.getUnit((Class)concreteClass, (Method)m), (Subjoin)subjoin, token), (CallableClosure)new CallableClosure(){

                        public Object call() throws Throwable {
                            return m.invoke(BeanProviderFacade.getBeanProvider().getBean(concreteClass), objects);
                        }
                    });
                    ConcurrentHashMap<String, String> toClient = new ConcurrentHashMap<String, String>();
                    Map subjoinMap = subjoin.toMap();
                    if (subjoinMap.size() > 0) {
                        toClient.put("subjoin", DubboApplication.objectToStr(subjoin.toMap()));
                    }
                    try {
                        String newTokenId = token.getTokenId();
                        if (!Common.isBlank((String)newTokenId) && !Common.isSameStr((String)newTokenId, (String)tokenId)) {
                            toClient.put("CONCRETE-TOKEN-ID", newTokenId);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (result != null) {
                        toClient.put("result", DubboApplication.objectToStr(result));
                    }
                    return toClient;
                }
            });
        }
    }

    private static class DubboCaller
    implements Caller {
        public static final String UNKNOWN = "unknown";
        private final String address;
        private final String agent;

        public DubboCaller(String address, String agent) {
            this.address = Common.isBlank((String)address) ? UNKNOWN : address;
            this.agent = Common.isBlank((String)agent) ? UNKNOWN : agent;
        }

        public String getAddress() {
            return this.address;
        }

        public String getAgent() {
            return this.agent;
        }
    }
}

