/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs.swagger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.jaxrs.DefaultJaxrsClassGetter;
import org.coodex.concrete.jaxrs.Polling;
import org.coodex.concrete.jaxrs.ServiceRegisteredListener;
import org.coodex.concrete.jaxrs.swagger.SwaggerHelper;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class Swagger
implements DefaultJaxrsClassGetter,
ServiceRegisteredListener {
    private static final Logger log = LoggerFactory.getLogger(Swagger.class);
    private static Singleton<Set<Class>> classes = new Singleton(LinkedHashSet::new);
    private static SingletonMap<String, String> swaggerJson = new SingletonMap(key -> SwaggerHelper.toJson((String)key, new ArrayList((Collection)classes.get())));
    private static String[] swagger_files = new String[]{"favicon-16x16.png", "favicon-32x32.png", "index.html", "oauth2-redirect.html", "swagger-ui.css", "swagger-ui.js", "swagger-ui-bundle.js", "swagger-ui-standalone-preset.js"};
    private static SingletonMap<String, StaticFileContent> staticFileContents = new SingletonMap(key -> {
        if (Common.inArray((Object)key, (Object[])swagger_files)) {
            StaticFileContent staticFileContent;
            String type = "text/html";
            if (key.endsWith(".css")) {
                type = "text/css";
            } else if (key.endsWith(".js")) {
                type = "application/javascript";
            } else if (key.endsWith(".png")) {
                type = "image/png";
            }
            InputStream inputStream = Common.getResource((String)("swagger/" + key), (ClassLoader[])new ClassLoader[0]).openStream();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Common.copyStream((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                StaticFileContent fileContent = new StaticFileContent();
                fileContent.type = type;
                fileContent.content = byteArrayOutputStream.toByteArray();
                staticFileContent = fileContent;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    log.warn("load file failed: {}.", key, (Object)e);
                }
            }
            inputStream.close();
            return staticFileContent;
        }
        return null;
    });
    @Context
    private UriInfo uri;
    @Context
    private UriInfo uriInfo;

    public Class[] getClasses() {
        Class[] classArray;
        if (Common.toBool((String)ConcreteHelper.getString((String)"swagger", null, (String)"swagger"), (boolean)true)) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Swagger.class;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    public void register(Object instance, Class concreteService) {
        if (Polling.class.equals((Object)concreteService)) {
            return;
        }
        ((Set)classes.get()).add(concreteService);
    }

    private String getContextPath() {
        return this.uri.getBaseUri().getPath();
    }

    @Path(value="swagger/config/swagger.json")
    @GET
    public Response swaggerJson() {
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE.withCharset("utf-8")).entity(swaggerJson.get((Object)this.getContextPath())).build();
    }

    @Path(value="swagger/{file}")
    @GET
    public Response getStaticFile(@PathParam(value="file") String file) {
        StaticFileContent fileContent;
        if (Common.isBlank((String)file)) {
            file = "index.html";
        }
        if ((fileContent = (StaticFileContent)staticFileContents.get((Object)file)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().type(fileContent.type).entity((Object)new ByteArrayInputStream(fileContent.content)).build();
    }

    @GET
    @Path(value="swagger")
    public Response index() throws URISyntaxException {
        return Response.seeOther((URI)new URI(this.uriInfo.getBaseUri() + "swagger/index.html")).build();
    }

    static class StaticFileContent {
        String type;
        byte[] content;

        StaticFileContent() {
        }
    }
}

