/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.Priority;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.ConcreteClosure;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.concrete.jaxrs.ClassGenerator;
import org.coodex.concrete.jaxrs.CreatedByConcrete;
import org.coodex.pojomocker.POJOMocker;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public abstract class AbstractJAXRSResource<T extends ConcreteService> {
    public static final String TOKEN_ID_IN_COOKIE = "CONCRETE_JAXRS_TOKENID";
    private final Class<T> clz = this.getInterfaceClass();
    @Context
    protected UriInfo uriInfo;
    private final Map<String, Method> methodMap = new HashMap<String, Method>();

    private <R> R convert(R result) {
        if (result == null) {
            return null;
        }
        if (result instanceof String && ConcreteHelper.getProfile().getBool("service.result.quoteSingleStr", true)) {
            return (R)JSON.toJSONString(result);
        }
        return result;
    }

    protected int getPriority(Method method) {
        Priority priority = method.getAnnotation(Priority.class);
        if (priority == null) {
            priority = this.getInterfaceClass().getAnnotation(Priority.class);
        }
        return priority == null ? 5 : Math.max(1, Math.min(10, priority.value()));
    }

    private Token getToken(String tokenId, boolean force) {
        return ((TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class)).getToken(tokenId, force);
    }

    private Class<T> getInterfaceClass() {
        return (Class)TypeHelper.findActualClassFrom(AbstractJAXRSResource.class.getTypeParameters()[0], this.getClass());
    }

    protected T getInstance() {
        return (T)((ConcreteService)BeanProviderFacade.getBeanProvider().getBean(this.clz));
    }

    private static String getMethodNameInStack(int deep) {
        return Thread.currentThread().getStackTrace()[deep + 2].getMethodName();
    }

    protected final Object mockResult() {
        return this.__mockResult();
    }

    private Object __mockResult() {
        try {
            Method method = this.findMethod(AbstractJAXRSResource.getMethodNameInStack(2), this.getClass());
            if (method.getReturnType() == Void.TYPE) {
                return null;
            }
            return this.convert(POJOMocker.mock((Type)method.getGenericReturnType(), this.getInterfaceClass()));
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new ConcreteException(99999, new Object[]{th.getLocalizedMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method findMethod(String methodName, Class<?> c) {
        String methodKey = AbstractJAXRSResource.getMethodNameInStack(3);
        Map<String, Method> map = this.methodMap;
        synchronized (map) {
            Method found = this.methodMap.get(methodKey);
            if (found == null) {
                Class<Object> clz = c == null ? this.getInterfaceClass() : c;
                for (Method method : this.getClass().getMethods()) {
                    if (!method.getName().equals(methodKey) || method.getAnnotation(CreatedByConcrete.class) == null) continue;
                    Class<?>[] parameterTypes = this.getParameterTypes(method.getParameterTypes());
                    try {
                        found = clz.getMethod(methodName, parameterTypes);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (found == null) {
                    throw new NullPointerException("no impl found for: " + clz.getName() + "." + methodName);
                }
                this.methodMap.put(methodKey, found);
            }
            return found;
        }
    }

    protected abstract int getMethodStartIndex();

    private Class<?>[] getParameterTypes(Class<?>[] parameterTypes) {
        if (ClassGenerator.FRONTEND_DEV_MODE) {
            return parameterTypes;
        }
        int count = parameterTypes.length - this.getMethodStartIndex();
        Class[] result = new Class[count];
        if (count > 0) {
            System.arraycopy(parameterTypes, this.getMethodStartIndex(), result, 0, count);
        }
        return result;
    }

    protected Response invokeByTokenId(String tokenId, final Method method, final Object[] params) {
        Object result;
        Response.ResponseBuilder builder;
        Token token;
        final int paramCount = params == null ? 0 : params.length;
        boolean newToken = false;
        Token token2 = token = Common.isBlank((String)tokenId) ? null : this.getToken(tokenId, false);
        if (token == null || !token.isValid()) {
            token = this.getToken(Common.getUUIDStr(), true);
            newToken = true;
        }
        Response.ResponseBuilder responseBuilder = builder = (result = this.convert(TokenWrapper.closure((Token)token, (ConcreteClosure)new ConcreteClosure(){

            public Object concreteRun() throws Throwable {
                Object instance = BeanProviderFacade.getBeanProvider().getBean(AbstractJAXRSResource.this.getInterfaceClass());
                if (paramCount == 0) {
                    return method.invoke(instance, new Object[0]);
                }
                return method.invoke(instance, params);
            }
        }))) == null ? Response.noContent() : Response.ok();
        if (newToken) {
            URI root = this.uriInfo.getBaseUri();
            String cookiePath = ConcreteHelper.getProfile().getString("jaxrs.token.cookie.path");
            builder = builder.cookie(new NewCookie[]{new NewCookie(new Cookie(TOKEN_ID_IN_COOKIE, token.getTokenId(), Common.isBlank((String)cookiePath) ? root.getPath() : cookiePath, null))});
        }
        if (result != null) {
            builder = builder.entity(result);
        }
        return builder.build();
    }
}

