/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.ConcreteSPIFacade;
import org.coodex.concrete.common.ConcreteToolkit;
import org.coodex.concrete.common.ErrorCodes;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.ClassGenerator;
import org.coodex.concrete.jaxrs.ErrorDefinition;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.util.ClassFilter;
import org.coodex.util.ReflectHelper;

public class JaxRSServiceHelper {
    private static final ConcreteSPIFacade<ClassGenerator> CLASS_GENERATORS = new ConcreteSPIFacade<ClassGenerator>(){};
    private static final ClassFilter CONCRETE_ERROR = new ClassFilter(){

        public boolean accept(Class<?> clazz) {
            return clazz != null && AbstractErrorCodes.class.isAssignableFrom(clazz);
        }
    };

    private static ClassGenerator getGenerator(String desc) {
        for (ClassGenerator classGenerator : CLASS_GENERATORS.getAllInstances()) {
            if (!classGenerator.isAccept(desc)) continue;
            return classGenerator;
        }
        throw new RuntimeException("no class generator found for " + desc + ".");
    }

    public static Set<Class<?>> generate(String desc, String ... packages) {
        HashSet classes = new HashSet();
        ClassGenerator classGenerator = JaxRSServiceHelper.getGenerator(desc);
        JaxRSServiceHelper.registErrorCodes(packages);
        List modules = ConcreteToolkit.loadModules((String)desc, (String[])packages);
        try {
            for (Module module : modules) {
                classes.add(classGenerator.generatesImplClass(module));
            }
            return classes;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static void foreachErrorClass(ReflectHelper.Processer processor, String ... packages) {
        ReflectHelper.foreachClass((ReflectHelper.Processer)processor, (ClassFilter)CONCRETE_ERROR, (String[])packages);
    }

    private static void registErrorCodes(String[] packages) {
        ErrorMessageFacade.register((Class[])new Class[]{AbstractErrorCodes.class, ErrorCodes.class});
        JaxRSServiceHelper.foreachErrorClass(new ReflectHelper.Processer(){

            public void process(Class<?> serviceClass) {
                if (AbstractErrorCodes.class.isAssignableFrom(serviceClass)) {
                    ErrorMessageFacade.register((Class[])new Class[]{serviceClass});
                }
            }
        }, packages);
    }

    public static List<ErrorDefinition> getAllErrorInfo(String ... packages) {
        ArrayList<ErrorDefinition> errorDefinitions = new ArrayList<ErrorDefinition>();
        JaxRSServiceHelper.registErrorCodes(packages);
        for (Integer i : ErrorMessageFacade.allRegisteredErrorCodes()) {
            errorDefinitions.add(new ErrorDefinition(i));
        }
        Collections.sort(errorDefinitions);
        return errorDefinitions;
    }
}

