/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteClosure;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.jaxrs.CreatedByConcrete;
import org.coodex.concrete.jaxrs.JAXRSServiceContext;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.concrete.jaxrs.JaxRSSubjoin;
import org.coodex.concrete.jaxrs.Polling;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public abstract class AbstractJAXRSResource<T extends ConcreteService> {
    public static final String TOKEN_ID_IN_COOKIE = "CONCRETE-TOKEN-ID";
    private final Class<T> clz = this.getInterfaceClass();
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders httpHeaders;
    @Context
    protected HttpServletRequest httpRequest;
    private final Map<String, Method> methodMap = new HashMap<String, Method>();

    private static boolean isDevModel() {
        return ConcreteHelper.isDevModel((String)"jaxrs");
    }

    private <R> R convert(R result) {
        return result;
    }

    protected int getPriority(Method method) {
        return ConcreteHelper.getPriority((Method)method, this.clz);
    }

    private Token getToken(String tokenId, boolean force) {
        return ((TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class)).getToken(tokenId, force);
    }

    protected Class<T> getInterfaceClass() {
        return TypeHelper.typeToClass((Type)TypeHelper.solve(AbstractJAXRSResource.class.getTypeParameters()[0], (Type[])new Type[]{this.getClass()}));
    }

    private static String getMethodNameInStack(int deep) {
        return Thread.currentThread().getStackTrace()[deep + 2].getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method findMethod(String methodName, Class<?> c) {
        String methodKey = AbstractJAXRSResource.getMethodNameInStack(3);
        Map<String, Method> map = this.methodMap;
        synchronized (map) {
            Method found = this.methodMap.get(methodKey);
            if (found == null) {
                Class<Object> clz = c == null ? this.getInterfaceClass() : c;
                for (Method method : this.getClass().getMethods()) {
                    if (!method.getName().equals(methodKey) || method.getAnnotation(CreatedByConcrete.class) == null) continue;
                    found = this.findActualMethod(methodName, clz, method.getAnnotation(CreatedByConcrete.class));
                    break;
                }
                if (found == null) {
                    throw new NullPointerException("no impl found for: " + clz.getName() + "." + methodName);
                }
                this.methodMap.put(methodKey, found);
            }
            return found;
        }
    }

    private int getParameterCount(Method method) {
        return method.getParameterTypes() == null ? 0 : method.getParameterTypes().length;
    }

    private Method findActualMethod(String methodName, Class<?> clz, CreatedByConcrete concrete) {
        for (Method m : clz.getMethods()) {
            if (!m.getName().equals(methodName) || this.getParameterCount(m) != concrete.paramCount()) continue;
            return m;
        }
        throw new RuntimeException("no such method: " + methodName + ", paramCount: " + concrete.paramCount());
    }

    protected abstract int getMethodStartIndex();

    private Class<?>[] getParameterTypes(Class<?>[] parameterTypes) {
        if (AbstractJAXRSResource.isDevModel()) {
            return parameterTypes;
        }
        int count = parameterTypes.length - this.getMethodStartIndex();
        Class[] result = new Class[count];
        if (count > 0) {
            System.arraycopy(parameterTypes, this.getMethodStartIndex(), result, 0, count);
        }
        return result;
    }

    protected ServiceContext buildContext(Token token, AbstractUnit unit) {
        return new JAXRSServiceContext(new Caller(){

            public String getAddress() {
                String xff = AbstractJAXRSResource.this.httpHeaders.getHeaderString("X-Forwarded-For");
                if (xff != null) {
                    return xff.split(",")[0].trim();
                }
                return AbstractJAXRSResource.this.httpRequest.getRemoteAddr();
            }

            public String getAgent() {
                return AbstractJAXRSResource.this.httpHeaders.getHeaderString("User-Agent");
            }
        }, token, unit, this.getSubjoin());
    }

    protected Response buildResponse(String tokenId, Method method, Object[] params, RunWithToken runWithToken) {
        Object result;
        Response.ResponseBuilder builder;
        Token token;
        boolean newToken = false;
        Token token2 = token = Common.isBlank((String)tokenId) ? null : this.getToken(tokenId, false);
        if (token == null || !token.isValid()) {
            token = this.getToken(Common.getUUIDStr(), true);
            newToken = true;
        }
        Response.ResponseBuilder responseBuilder = builder = (result = runWithToken.runWithToken(token)) == null ? Response.noContent() : Response.ok();
        if (newToken) {
            builder = this.setTokenInfo(token, builder);
        }
        if (result != null) {
            builder = builder.entity(result);
            builder = result instanceof String ? this.textType(builder) : this.jsonType(builder);
        }
        return builder.build();
    }

    protected Response invokeByTokenId(String tokenId, final Method method, final Object[] params) {
        final int paramCount = params == null ? 0 : params.length;
        return this.buildResponse(tokenId, method, params, new RunWithToken(){

            @Override
            public Object runWithToken(Token token) {
                return AbstractJAXRSResource.this.convert(ConcreteContext.runWithContext((ServiceContext)AbstractJAXRSResource.this.buildContext(token, (AbstractUnit)JaxRSHelper.getUnitFromContext((DefinitionContext)ConcreteHelper.getContext((Method)method, AbstractJAXRSResource.this.getInterfaceClass()))), (ConcreteClosure)new ConcreteClosure(){

                    public Object concreteRun() throws Throwable {
                        if (!Polling.class.equals(method.getDeclaringClass()) && AbstractJAXRSResource.isDevModel()) {
                            return Void.TYPE.equals(method.getGenericReturnType()) ? null : MockerFacade.mock((Method)method, (Class[])new Class[]{AbstractJAXRSResource.this.getInterfaceClass()});
                        }
                        Object instance = BeanProviderFacade.getBeanProvider().getBean(AbstractJAXRSResource.this.getInterfaceClass());
                        if (paramCount == 0) {
                            return method.invoke(instance, new Object[0]);
                        }
                        return method.invoke(instance, params);
                    }
                }));
            }
        });
    }

    protected abstract Response.ResponseBuilder textType(Response.ResponseBuilder var1);

    protected abstract Response.ResponseBuilder jsonType(Response.ResponseBuilder var1);

    private Subjoin getSubjoin() {
        return new JaxRSSubjoin(this.httpHeaders);
    }

    protected Response.ResponseBuilder setTokenInfo(Token token, Response.ResponseBuilder builder) {
        return builder.header(TOKEN_ID_IN_COOKIE, (Object)token.getTokenId());
    }

    public class ResponseBuilder {
        private final String tokenId;
        private final Method method;
        private final Object[] params;

        public ResponseBuilder(String tokenId, Method method, Object[] params) {
            this.tokenId = tokenId;
            this.method = method;
            this.params = params;
        }

        public Response build(RunWithToken runWithToken) {
            return AbstractJAXRSResource.this.buildResponse(this.tokenId, this.method, this.params, runWithToken);
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getParams() {
            return this.params;
        }
    }

    public static interface RunWithToken {
        public Object runWithToken(Token var1);
    }
}

