/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.jaxrs.ErrorCodeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ConcreteExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ConcreteExceptionMapper.class);
    private static final ConcreteServiceLoader<ErrorCodeMapper> CODE_MAPPER_SERVICE_LOADER = new ConcreteServiceLoader<ErrorCodeMapper>(){
        private ErrorCodeMapper errorCodeMapper = new ErrorCodeMapper(){

            @Override
            public Response.Status toStatus(int errorCode) {
                switch (errorCode) {
                    case 1001: 
                    case 1002: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 99999: {
                        return Response.Status.INTERNAL_SERVER_ERROR;
                    }
                    case 1003: 
                    case 1004: {
                        return Response.Status.UNAUTHORIZED;
                    }
                    case 1006: 
                    case 1008: {
                        return Response.Status.FORBIDDEN;
                    }
                    case 1014: {
                        return Response.Status.SERVICE_UNAVAILABLE;
                    }
                }
                return Response.Status.BAD_REQUEST;
            }
        };

        protected ErrorCodeMapper getConcreteDefaultProvider() {
            return this.errorCodeMapper;
        }
    };

    protected Response.Status getStatus(int errorCode) {
        return ((ErrorCodeMapper)CODE_MAPPER_SERVICE_LOADER.getInstance()).toStatus(errorCode);
    }

    public Response toResponse(Throwable exception) {
        Response.Status status;
        int errorCode = 99999;
        ConcreteException concreteException = ConcreteHelper.findException((Throwable)exception);
        if (concreteException != null) {
            errorCode = concreteException.getCode();
            exception = concreteException;
        }
        if ((status = this.getStatus(errorCode)).getFamily() == Response.Status.Family.SERVER_ERROR) {
            log.warn("exception occurred: {}", (Object)exception.getLocalizedMessage(), (Object)exception);
        }
        return Response.status((Response.Status)status).header("Content-Type", (Object)"application/json").header("CONCRETE-ERROR-OCCURRED", (Object)true).entity((Object)new ErrorInfo(errorCode, exception.getLocalizedMessage())).build();
    }
}

