/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorCodes;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.ClassGenerator;
import org.coodex.concrete.jaxrs.ConcreteExceptionMapper;
import org.coodex.concrete.jaxrs.JaxRSModuleMaker;
import org.coodex.concrete.jaxrs.Polling;
import org.coodex.util.ReflectHelper;

public abstract class ConcreteJaxrsApplication
extends Application {
    protected Set<Class<? extends ConcreteService>> servicesClasses = new HashSet<Class<? extends ConcreteService>>();
    protected Set<Class<?>> jaxrsClasses = new HashSet();
    protected Set<Object> singletonInstances = new HashSet<Object>();
    protected Set<Class<?>> othersClasses = new HashSet();
    protected Application application = null;
    protected static final JaxRSModuleMaker moduleMaker = new JaxRSModuleMaker();

    public ConcreteJaxrsApplication() {
        this.registerDefault();
    }

    protected abstract ClassGenerator getClassGenerator();

    public ConcreteJaxrsApplication(Application application) {
        this.application = application;
        this.registerDefault();
    }

    protected void registerDefault() {
        this.register(ConcreteExceptionMapper.class, Polling.class);
        this.registerPackage(ErrorCodes.class.getPackage().getName());
    }

    public void registerPackage(String ... packages) {
        ConcreteHelper.foreachClassInPackages((ReflectHelper.Processor)new ReflectHelper.Processor(){

            public void process(Class<?> serviceClass) {
                ConcreteJaxrsApplication.this.registerClass(serviceClass);
            }
        }, (String[])packages);
    }

    public void register(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.registerClass(clz);
        }
    }

    private Object newInstance(Class<?> clz) {
        try {
            return clz.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new UnableNewInstanceException(th);
        }
    }

    protected void registerConcreteService(Class<? extends ConcreteService> concreteServiceClass) {
        if (!this.servicesClasses.contains(concreteServiceClass)) {
            this.servicesClasses.add(concreteServiceClass);
            Class<?> jaxrs = this.generateJaxrsClass(concreteServiceClass);
            if (jaxrs != null) {
                this.jaxrsClasses.add(jaxrs);
            }
        }
    }

    protected Class<?> generateJaxrsClass(Class<?> concreteServiceClass) {
        try {
            return this.getClassGenerator().generatesImplClass(moduleMaker.make(concreteServiceClass));
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void registerClass(Class<?> clz) {
        if (ConcreteHelper.isConcreteService(clz)) {
            this.registerConcreteService(clz);
        } else if (AbstractErrorCodes.class.isAssignableFrom(clz)) {
            ErrorMessageFacade.register((Class[])new Class[]{clz});
        } else if (!this.othersClasses.contains(clz)) {
            this.othersClasses.add(clz);
            if (clz.getAnnotation(Provider.class) != null) {
                this.singletonInstances.add(this.newInstance(clz));
            }
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet set = new HashSet();
        if (this.application != null) {
            set.addAll(this.application.getClasses());
        }
        set.addAll(this.jaxrsClasses);
        set.addAll(this.othersClasses);
        return Collections.unmodifiableSet(set);
    }

    public Set<Object> getSingletons() {
        HashSet<Object> set = new HashSet<Object>();
        if (this.application != null) {
            set.addAll(this.application.getSingletons());
        }
        set.addAll(this.singletonInstances);
        return Collections.unmodifiableSet(set);
    }

    private class UnableNewInstanceException
    extends RuntimeException {
        public UnableNewInstanceException(Throwable th) {
            super(th);
        }
    }
}

