/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.messages.Message;
import org.coodex.concrete.core.messages.Courier;
import org.coodex.concrete.jaxrs.AsyncMessageReceiver;
import org.coodex.concurrent.ExecutorsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRSCourier
implements Courier {
    private static final Logger log = LoggerFactory.getLogger(JaxRSCourier.class);
    private static final long MAX_LIFE = 300000L;
    private static final Map<String, Queue<MessageWithArrived>> queueMap = new HashMap<String, Queue<MessageWithArrived>>();
    private static final Map<Queue<MessageWithArrived>, Set<AsyncMessageReceiver>> ASYNC_MESSAGE_GETTER_MAP = new HashMap<Queue<MessageWithArrived>, Set<AsyncMessageReceiver>>();
    private static ScheduledExecutorService scheduledExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxRSCourier() {
        Class<JaxRSCourier> clazz = JaxRSCourier.class;
        synchronized (JaxRSCourier.class) {
            if (scheduledExecutorService == null) {
                scheduledExecutorService = ExecutorsHelper.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<MessageWithArrived> getQueue(String tokenId) {
        Map<String, Queue<MessageWithArrived>> map = queueMap;
        synchronized (map) {
            if (!queueMap.containsKey(tokenId)) {
                LinkedBlockingQueue<MessageWithArrived> queue = new LinkedBlockingQueue<MessageWithArrived>();
                queueMap.put(tokenId, queue);
                JaxRSCourier.clean(queue, System.currentTimeMillis() + 300000L);
            }
        }
        return queueMap.get(tokenId);
    }

    private static void clean(final Queue<MessageWithArrived> queue, final long deathLine) {
        long time = Math.max(deathLine - System.currentTimeMillis(), 1000L);
        scheduledExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Queue queue2 = queue;
                synchronized (queue2) {
                    MessageWithArrived head = (MessageWithArrived)queue.peek();
                    while (head != null && head.arrived <= deathLine) {
                        queue.remove();
                        head = (MessageWithArrived)queue.peek();
                    }
                    JaxRSCourier.clean(queue, head == null ? System.currentTimeMillis() + 300000L : head.arrived);
                    queue.notifyAll();
                }
            }
        }, time, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncMessageReceive(String tokenId, AsyncMessageReceiver asyncMessageReceiver) {
        Queue<MessageWithArrived> queue = JaxRSCourier.getQueue(tokenId);
        Map<Queue<MessageWithArrived>, Set<AsyncMessageReceiver>> map = ASYNC_MESSAGE_GETTER_MAP;
        synchronized (map) {
            Set<AsyncMessageReceiver> asyncMessageReceiverSet;
            Set<AsyncMessageReceiver> set = asyncMessageReceiverSet = JaxRSCourier.getAsyncMessageReceivers(queue);
            synchronized (set) {
                if (!asyncMessageReceiverSet.contains(asyncMessageReceiver)) {
                    List<Message> messages = JaxRSCourier.getMessage(tokenId, -1L);
                    if (messages.size() > 0) {
                        asyncMessageReceiver.resume(messages);
                    } else {
                        asyncMessageReceiverSet.add(asyncMessageReceiver);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<AsyncMessageReceiver> getAsyncMessageReceivers(Queue<MessageWithArrived> queue) {
        HashSet<AsyncMessageReceiver> asyncMessageReceiverSet = null;
        Map<Queue<MessageWithArrived>, Set<AsyncMessageReceiver>> map = ASYNC_MESSAGE_GETTER_MAP;
        synchronized (map) {
            if (!ASYNC_MESSAGE_GETTER_MAP.containsKey(queue)) {
                asyncMessageReceiverSet = new HashSet();
                ASYNC_MESSAGE_GETTER_MAP.put(queue, asyncMessageReceiverSet);
            }
            asyncMessageReceiverSet = ASYNC_MESSAGE_GETTER_MAP.get(queue);
        }
        return asyncMessageReceiverSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> getMessage(String tokenId, long timeOut) {
        Queue<MessageWithArrived> queue = JaxRSCourier.getQueue(tokenId);
        ArrayList<Message> messages = new ArrayList<Message>();
        Queue<MessageWithArrived> queue2 = queue;
        synchronized (queue2) {
            try {
                if (queue.isEmpty()) {
                    try {
                        if (timeOut >= 0L) {
                            queue.wait(timeOut);
                        }
                    }
                    catch (Throwable e) {
                        log.warn("{}", (Object)e.getLocalizedMessage(), (Object)e);
                    }
                }
                while (!queue.isEmpty()) {
                    messages.add(queue.poll().message);
                }
            }
            finally {
                queue.notify();
            }
        }
        return messages;
    }

    public String getType() {
        return "JAXRS_COURIER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void pushTo(Message<T> message, Token token) {
        Queue<MessageWithArrived> queue;
        Queue<MessageWithArrived> queue2 = queue = JaxRSCourier.getQueue(token.getTokenId());
        synchronized (queue2) {
            boolean handle = false;
            try {
                Map<Queue<MessageWithArrived>, Set<AsyncMessageReceiver>> map = ASYNC_MESSAGE_GETTER_MAP;
                synchronized (map) {
                    for (AsyncMessageReceiver receiver : JaxRSCourier.getAsyncMessageReceivers(queue)) {
                        try {
                            handle = true;
                            receiver.resume(Arrays.asList(message));
                        }
                        catch (Throwable throwable) {
                            log.warn("{}", (Object)throwable.getLocalizedMessage(), (Object)throwable);
                        }
                    }
                }
            }
            finally {
                if (!handle) {
                    queue.add(new MessageWithArrived(message));
                    queue.notify();
                } else {
                    ASYNC_MESSAGE_GETTER_MAP.remove(queue);
                }
            }
        }
    }

    public static void deregister(AsyncMessageReceiver getter) {
        JaxRSCourier.getAsyncMessageReceivers(getter.getKey()).remove(getter);
    }

    private class MessageWithArrived {
        private final Message message;
        private final long arrived = System.currentTimeMillis();

        public MessageWithArrived(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }

        public long getArrived() {
            return this.arrived;
        }
    }
}

