/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.ConcreteClassFilter;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.ClassGenerator;
import org.coodex.concrete.jaxrs.ErrorDefinition;
import org.coodex.concrete.jaxrs.Polling;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;

public class JaxRSServiceHelper {
    private static final ConcreteServiceLoader<ClassGenerator> CLASS_GENERATORS = new ConcreteServiceLoader<ClassGenerator>(){};
    private static final Set<Class> REGISTERED = new HashSet<Class>();
    private static final ClassNameFilter CONCRETE_ERROR = new ConcreteClassFilter(){

        protected boolean accept(Class<?> clazz) {
            return clazz != null && AbstractErrorCodes.class.isAssignableFrom(clazz);
        }
    };

    private static ClassGenerator getGenerator(String desc) {
        for (ClassGenerator classGenerator : CLASS_GENERATORS.getAllInstances()) {
            if (!classGenerator.isAccept(desc)) continue;
            return classGenerator;
        }
        throw new RuntimeException("no class generator found for " + desc + ".");
    }

    private static String[] addDefaults(String[] packages) {
        Set<String> set = packages == null ? new HashSet() : Common.arrayToSet((Object[])packages);
        set.add(Polling.class.getPackage().getName());
        return set.toArray(new String[0]);
    }

    @Deprecated
    public static synchronized Set<Class<?>> generate(String desc, String ... packages) {
        return JaxRSServiceHelper.generateByPackages(desc, packages);
    }

    private static Class<?> buildServiceImpl(String desc, Class<? extends ConcreteService> serviceClass) {
        try {
            return JaxRSServiceHelper.getGenerator(desc).generatesImplClass((Module)ConcreteHelper.loadModule((String)desc, Polling.class));
        }
        catch (RuntimeException th) {
            throw th;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static synchronized Set<Class<?>> generateByClasses(String desc, Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return JaxRSServiceHelper.generateByPackages(desc, new String[0]);
        }
        HashSet result = new HashSet();
        HashSet set = new HashSet();
        if (!REGISTERED.contains(Polling.class)) {
            result.add(JaxRSServiceHelper.buildServiceImpl(desc, Polling.class));
            set.add(Polling.class);
        }
        for (Class<?> clz : classes) {
            if (AbstractErrorCodes.class.isAssignableFrom(clz)) {
                ErrorMessageFacade.register((Class[])new Class[]{clz});
                continue;
            }
            if (ConcreteHelper.isConcreteService(clz)) {
                if (REGISTERED.contains(clz) || set.contains(clz)) continue;
                result.add(JaxRSServiceHelper.buildServiceImpl(desc, clz));
                set.add(clz);
                continue;
            }
            throw new RuntimeException("unable register class: " + clz.getName());
        }
        REGISTERED.addAll(set);
        return result;
    }

    public static synchronized Set<Class<?>> generateByPackages(String desc, String ... packages) {
        if (packages == null || packages.length == 0) {
            packages = ConcreteHelper.getApiPackages();
        }
        packages = JaxRSServiceHelper.addDefaults(packages);
        HashSet classes = new HashSet();
        ClassGenerator classGenerator = JaxRSServiceHelper.getGenerator(desc);
        JaxRSServiceHelper.registErrorCodes(packages);
        List modules = ConcreteHelper.loadModules((String)desc, (String[])packages);
        try {
            HashSet<Class> set = new HashSet<Class>();
            for (Module module : modules) {
                if (REGISTERED.contains(module.getInterfaceClass()) || set.contains(module.getInterfaceClass())) continue;
                classes.add(classGenerator.generatesImplClass(module));
                set.add(module.getInterfaceClass());
            }
            REGISTERED.addAll(set);
            return classes;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static void foreachErrorClass(ReflectHelper.Processor processor, String ... packages) {
        ReflectHelper.foreachClass((ReflectHelper.Processor)processor, (ClassNameFilter)CONCRETE_ERROR, (String[])packages);
    }

    private static void registErrorCodes(String[] packages) {
        ReflectHelper.Processor processor = new ReflectHelper.Processor(){

            public void process(Class<?> serviceClass) {
                if (AbstractErrorCodes.class.isAssignableFrom(serviceClass)) {
                    ErrorMessageFacade.register((Class[])new Class[]{serviceClass});
                }
            }
        };
        JaxRSServiceHelper.foreachErrorClass(processor, AbstractErrorCodes.class.getPackage().getName());
        JaxRSServiceHelper.foreachErrorClass(processor, packages);
    }

    public static List<ErrorDefinition> getAllErrorInfo(String ... packages) {
        ArrayList<ErrorDefinition> errorDefinitions = new ArrayList<ErrorDefinition>();
        JaxRSServiceHelper.registErrorCodes(packages);
        for (Integer i : ErrorMessageFacade.allRegisteredErrorCodes()) {
            errorDefinitions.add(new ErrorDefinition(i));
        }
        Collections.sort(errorDefinitions);
        return errorDefinitions;
    }
}

