/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.jaxrs.CreatedByConcrete;
import org.coodex.concrete.jaxrs.JAXRSServiceContext;
import org.coodex.concrete.jaxrs.JaxRSSubjoin;
import org.coodex.concrete.jaxrs.Polling;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public abstract class AbstractJAXRSResource<T extends ConcreteService> {
    private final Class<T> clz = this.getInterfaceClass();
    private final Map<String, Method> methodMap = new HashMap<String, Method>();
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders httpHeaders;
    @Context
    protected HttpServletRequest httpRequest;

    private static boolean isDevModel() {
        return ConcreteHelper.isDevModel((String)"jaxrs");
    }

    private static String getMethodNameInStack(int deep) {
        return Thread.currentThread().getStackTrace()[deep + 2].getMethodName();
    }

    private <R> R convert(R result) {
        return result;
    }

    protected int getPriority(Method method) {
        return ConcreteHelper.getPriority((Method)method, this.clz);
    }

    protected Class<T> getInterfaceClass() {
        return TypeHelper.typeToClass((Type)TypeHelper.solve(AbstractJAXRSResource.class.getTypeParameters()[0], (Type[])new Type[]{this.getClass()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method findMethod(String methodName, Class<?> c) {
        String methodKey = AbstractJAXRSResource.getMethodNameInStack(3);
        Map<String, Method> map = this.methodMap;
        synchronized (map) {
            Method found = this.methodMap.get(methodKey);
            if (found == null) {
                Class<Object> clz = c == null ? this.getInterfaceClass() : c;
                for (Method method : this.getClass().getMethods()) {
                    if (!method.getName().equals(methodKey) || method.getAnnotation(CreatedByConcrete.class) == null) continue;
                    found = this.findActualMethod(methodName, clz, method.getAnnotation(CreatedByConcrete.class));
                    break;
                }
                if (found == null) {
                    throw new NullPointerException("no impl found for: " + clz.getName() + "." + methodName);
                }
                this.methodMap.put(methodKey, found);
            }
            return found;
        }
    }

    private int getParameterCount(Method method) {
        return method.getParameterTypes() == null ? 0 : method.getParameterTypes().length;
    }

    private Method findActualMethod(String methodName, Class<?> clz, CreatedByConcrete concrete) {
        for (Method m : clz.getMethods()) {
            if (!m.getName().equals(methodName) || this.getParameterCount(m) != concrete.paramCount()) continue;
            return m;
        }
        throw new RuntimeException("no such method: " + methodName + ", paramCount: " + concrete.paramCount());
    }

    protected abstract int getMethodStartIndex();

    private Class<?>[] getParameterTypes(Class<?>[] parameterTypes) {
        if (AbstractJAXRSResource.isDevModel()) {
            return parameterTypes;
        }
        int count = parameterTypes.length - this.getMethodStartIndex();
        Class[] result = new Class[count];
        if (count > 0) {
            System.arraycopy(parameterTypes, this.getMethodStartIndex(), result, 0, count);
        }
        return result;
    }

    protected JAXRSServiceContext buildContext(String tokenId) {
        return new JAXRSServiceContext(new Caller(){

            public String getAddress() {
                String xff = AbstractJAXRSResource.this.httpHeaders.getHeaderString("X-Forwarded-For");
                if (xff != null) {
                    return xff.split(",")[0].trim();
                }
                return AbstractJAXRSResource.this.httpRequest.getRemoteAddr();
            }

            public String getClientProvider() {
                return String.format("%s; %s", AbstractJAXRSResource.this.httpHeaders.getHeaderString("X-CLIENT-PROVIDER"), AbstractJAXRSResource.this.httpHeaders.getHeaderString("User-Agent"));
            }
        }, this.getSubjoin(), this.getRequestLocal(), tokenId);
    }

    private Locale getRequestLocal() {
        List locales = this.httpHeaders.getAcceptableLanguages();
        return locales == null || locales.size() == 0 ? null : (Locale)locales.get(0);
    }

    protected Response buildResponse(String tokenId, Method method, Object[] params, CallableClosure callable) {
        JAXRSServiceContext serviceContext = this.buildContext(tokenId);
        Trace trace = APM.build((Subjoin)serviceContext.getSubjoin()).tag("remote", serviceContext.getCaller().getAddress()).tag("agent", serviceContext.getCaller().getClientProvider()).start(String.format("jaxrs: %s.%s", method.getDeclaringClass().getName(), method.getName()));
        try {
            Object result = ConcreteContext.runWithContext((ServiceContext)serviceContext, (CallableClosure)callable);
            Response.ResponseBuilder builder = result == null ? Response.noContent() : Response.ok();
            String tokenIdAfterInvoke = serviceContext.getTokenId();
            if (!Common.isSameStr((String)tokenId, (String)tokenIdAfterInvoke) && !Common.isBlank((String)tokenIdAfterInvoke)) {
                builder = this.setTokenInfo(tokenIdAfterInvoke, builder);
            }
            if (result != null) {
                builder = builder.entity(result);
                builder = result instanceof String ? this.textType(builder) : this.jsonType(builder);
            }
            Response response = builder.build();
            return response;
        }
        catch (Throwable throwable) {
            trace.error(throwable);
            throw Common.runtimeException((Throwable)throwable);
        }
        finally {
            trace.finish();
        }
    }

    protected Response invokeByTokenId(String tokenId, final Method method, final Object[] params) {
        final int paramCount = params == null ? 0 : params.length;
        return this.buildResponse(tokenId, method, params, new CallableClosure(){

            public Object call() throws Throwable {
                if (!Polling.class.equals(method.getDeclaringClass()) && AbstractJAXRSResource.isDevModel()) {
                    return Void.TYPE.equals(method.getGenericReturnType()) ? null : MockerFacade.mock((Method)method, (Class[])new Class[]{AbstractJAXRSResource.this.getInterfaceClass()});
                }
                Object instance = BeanProviderFacade.getBeanProvider().getBean(AbstractJAXRSResource.this.getInterfaceClass());
                if (paramCount == 0) {
                    return method.invoke(instance, new Object[0]);
                }
                return method.invoke(instance, params);
            }
        });
    }

    protected abstract Response.ResponseBuilder textType(Response.ResponseBuilder var1);

    protected abstract Response.ResponseBuilder jsonType(Response.ResponseBuilder var1);

    private Subjoin getSubjoin() {
        return new JaxRSSubjoin(this.httpHeaders);
    }

    protected Response.ResponseBuilder setTokenInfo(String tokenId, Response.ResponseBuilder builder) {
        return builder.header("CONCRETE-TOKEN-ID", (Object)tokenId);
    }

    public class ResponseBuilder {
        private final String tokenId;
        private final Method method;
        private final Object[] params;

        public ResponseBuilder(String tokenId, Method method, Object[] params) {
            this.tokenId = tokenId;
            this.method = method;
            this.params = params;
        }

        public Response build(CallableClosure callable) {
            return AbstractJAXRSResource.this.buildResponse(this.tokenId, this.method, this.params, callable);
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getParams() {
            return this.params;
        }
    }

    public static interface RunWithToken {
        public Object runWithToken(Token var1);
    }
}

