/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.ThrowableMapperFacade;
import org.coodex.concrete.jaxrs.DefaultErrorCodeMapper;
import org.coodex.concrete.jaxrs.ErrorCodeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ConcreteExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ConcreteExceptionMapper.class);
    private static final ConcreteServiceLoader<ErrorCodeMapper> CODE_MAPPER_SERVICE_LOADER = new ConcreteServiceLoader<ErrorCodeMapper>(){
        private ErrorCodeMapper errorCodeMapper = new DefaultErrorCodeMapper();

        protected ErrorCodeMapper getConcreteDefaultProvider() {
            return this.errorCodeMapper;
        }
    };

    protected Response.Status getStatus(int errorCode) {
        return ((ErrorCodeMapper)CODE_MAPPER_SERVICE_LOADER.getInstance()).toStatus(errorCode);
    }

    public Response toResponse(Throwable exception) {
        ErrorInfo errorInfo = ThrowableMapperFacade.toErrorInfo((Throwable)exception);
        Response.Status status = this.getStatus(errorInfo.getCode());
        if (status.getFamily() == Response.Status.Family.SERVER_ERROR) {
            log.warn("exception occurred: {}", (Object)exception.getLocalizedMessage(), (Object)exception);
        }
        return Response.status((Response.Status)status).header("Content-Type", (Object)"application/json").header("CONCRETE-ERROR-OCCURRED", (Object)true).entity((Object)errorInfo).build();
    }
}

