/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.Provider;
import org.coodex.concrete.api.Application;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorCodes;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.ClassGenerator;
import org.coodex.concrete.jaxrs.ConcreteExceptionMapper;
import org.coodex.concrete.jaxrs.JaxRSModuleMaker;
import org.coodex.concrete.jaxrs.Polling;
import org.coodex.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConcreteJaxrsApplication
extends javax.ws.rs.core.Application
implements Application {
    protected static final JaxRSModuleMaker moduleMaker = new JaxRSModuleMaker();
    private static final Logger log = LoggerFactory.getLogger(ConcreteJaxrsApplication.class);
    private Set<Class<? extends ConcreteService>> servicesClasses = new HashSet<Class<? extends ConcreteService>>();
    private Set<Class<?>> jaxrsClasses = new HashSet();
    private Set<Object> singletonInstances = new HashSet<Object>();
    private Set<Class<?>> othersClasses = new HashSet();
    private javax.ws.rs.core.Application application = null;
    private boolean exceptionMapperRegisted = false;

    public ConcreteJaxrsApplication() {
        this.registerDefault();
    }

    public ConcreteJaxrsApplication(javax.ws.rs.core.Application application) {
        this.application = application;
        this.registerDefault();
    }

    public Set<Class<? extends ConcreteService>> getServicesClasses() {
        return this.servicesClasses;
    }

    public Set<Class<?>> getJaxrsClasses() {
        return this.jaxrsClasses;
    }

    public Set<Object> getSingletonInstances() {
        return this.singletonInstances;
    }

    public Set<Class<?>> getOthersClasses() {
        return this.othersClasses;
    }

    public javax.ws.rs.core.Application getApplication() {
        return this.application;
    }

    protected abstract ClassGenerator getClassGenerator();

    protected void registerDefault() {
        this.register(Polling.class);
        this.registerPackage(ErrorCodes.class.getPackage().getName());
    }

    public void registerPackage(String ... packages) {
        ConcreteHelper.foreachClassInPackages((ReflectHelper.Processor)new ReflectHelper.Processor(){

            public void process(Class<?> serviceClass) {
                ConcreteJaxrsApplication.this.registerClass(serviceClass);
            }
        }, (String[])packages);
    }

    public void register(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.registerClass(clz);
        }
    }

    private Object newInstance(Class<?> clz) {
        try {
            return clz.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new UnableNewInstanceException(th);
        }
    }

    protected void registerConcreteService(Class<? extends ConcreteService> concreteServiceClass) {
        if (!this.servicesClasses.contains(concreteServiceClass)) {
            this.servicesClasses.add(concreteServiceClass);
            Class<?> jaxrs = this.generateJaxrsClass(concreteServiceClass);
            if (jaxrs != null) {
                if (log.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\n\tclassName: ").append(jaxrs.getName()).append(";");
                    for (Method method : jaxrs.getMethods()) {
                        if (Object.class.equals(method.getDeclaringClass())) continue;
                        builder.append("\n\t\tmethod: ").append(method.getName()).append("(");
                        for (int i = 0; i < method.getGenericParameterTypes().length; ++i) {
                            if (i > 0) {
                                builder.append(", ");
                            }
                            if (method.getParameterAnnotations()[i] != null) {
                                for (Annotation annotation : method.getParameterAnnotations()[i]) {
                                    builder.append(annotation.annotationType().getName()).append(" ");
                                }
                            }
                            builder.append(method.getParameterTypes()[i].toString());
                        }
                        builder.append(");");
                    }
                    log.debug("class info:{}", (Object)builder.toString());
                }
                this.jaxrsClasses.add(jaxrs);
            }
        }
    }

    protected Class<?> generateJaxrsClass(Class<?> concreteServiceClass) {
        try {
            return this.getClassGenerator().generatesImplClass(moduleMaker.make(concreteServiceClass));
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void registerClass(Class<?> clz) {
        if (ConcreteHelper.isConcreteService(clz)) {
            this.registerConcreteService(clz);
        } else if (AbstractErrorCodes.class.isAssignableFrom(clz)) {
            ErrorMessageFacade.register((Class[])new Class[]{clz});
        } else {
            if (ConcreteExceptionMapper.class.isAssignableFrom(clz)) {
                this.exceptionMapperRegisted = true;
            }
            if (!this.othersClasses.contains(clz)) {
                this.othersClasses.add(clz);
                if (clz.getAnnotation(Provider.class) != null) {
                    this.singletonInstances.add(this.newInstance(clz));
                }
            }
        }
    }

    public Set<Class<?>> getClasses() {
        if (!this.exceptionMapperRegisted) {
            this.register(ConcreteExceptionMapper.class);
        }
        HashSet set = new HashSet();
        if (this.application != null) {
            set.addAll(this.application.getClasses());
        }
        set.addAll(this.jaxrsClasses);
        set.addAll(this.othersClasses);
        return Collections.unmodifiableSet(set);
    }

    public Set<Object> getSingletons() {
        if (!this.exceptionMapperRegisted) {
            this.register(ConcreteExceptionMapper.class);
        }
        HashSet<Object> set = new HashSet<Object>();
        if (this.application != null) {
            set.addAll(this.application.getSingletons());
        }
        set.addAll(this.singletonInstances);
        return Collections.unmodifiableSet(set);
    }

    private class UnableNewInstanceException
    extends RuntimeException {
        public UnableNewInstanceException(Throwable th) {
            super(th);
        }
    }
}

