/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.ThrowableMapperFacade;
import org.coodex.concrete.jaxrs.DefaultErrorCodeMapper;
import org.coodex.concrete.jaxrs.ErrorCodeMapper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ConcreteExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ConcreteExceptionMapper.class);
    private static final ServiceLoader<ErrorCodeMapper> CODE_MAPPER_SERVICE_LOADER = new ServiceLoaderImpl<ErrorCodeMapper>((ErrorCodeMapper)new DefaultErrorCodeMapper()){};

    protected Response.Status getStatus(int errorCode) {
        return ((ErrorCodeMapper)CODE_MAPPER_SERVICE_LOADER.get()).toStatus(errorCode);
    }

    public Response toResponse(Throwable exception) {
        ErrorInfo errorInfo = ThrowableMapperFacade.toErrorInfo((Throwable)exception);
        Response.Status status = this.getStatus(errorInfo.getCode());
        if (status.getFamily() == Response.Status.Family.SERVER_ERROR) {
            Throwable th = exception;
            if (exception instanceof ConcreteException) {
                if (((ConcreteException)exception).getCode() != 99999) {
                    th = null;
                } else {
                    th = exception.getCause();
                    if (th.getClass().getName().startsWith(InvocationTargetException.class.getPackage().getName())) {
                        th = th.getCause();
                    }
                }
            }
            if (th != null) {
                log.warn("exception occurred: {}", (Object)th.getLocalizedMessage(), (Object)th);
            } else {
                log.warn("exception occurred: {}", (Object)exception.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)status).header("Content-Type", (Object)"application/json").header("CONCRETE-ERROR-OCCURRED", (Object)true).entity((Object)errorInfo).build();
    }
}

