/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jaxrs;

import javax.ws.rs.core.Response;
import org.coodex.concrete.jaxrs.ErrorCodeMapper;

public class DefaultErrorCodeMapper
implements ErrorCodeMapper {
    @Override
    public Response.Status toStatus(int errorCode) {
        switch (errorCode) {
            case 1001: 
            case 1002: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 99999: {
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
            case 1003: 
            case 1004: {
                return Response.Status.UNAUTHORIZED;
            }
            case 1006: 
            case 1008: {
                return Response.Status.FORBIDDEN;
            }
            case 1014: {
                return Response.Status.SERVICE_UNAVAILABLE;
            }
        }
        Response.Status status = errorCode < 600 ? Response.Status.fromStatusCode((int)errorCode) : Response.Status.BAD_REQUEST;
        return status == null ? Response.Status.BAD_REQUEST : status;
    }
}

