/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.websocket;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorCodes;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.messages.Message;
import org.coodex.concrete.common.struct.AbstractParam;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.support.websocket.CallerHackConfigurator;
import org.coodex.concrete.support.websocket.WebSocketServiceContext;
import org.coodex.concrete.websocket.ConcreteWebSocketEndPoint;
import org.coodex.concrete.websocket.InvalidRequest;
import org.coodex.concrete.websocket.RequestPackage;
import org.coodex.concrete.websocket.ResponsePackage;
import org.coodex.concrete.websocket.SessionFilter;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.concrete.websocket.WebSocketSubjoin;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.concurrent.components.PriorityRunnable;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.util.Common;
import org.coodex.util.GenericType;
import org.coodex.util.ReflectHelper;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketServerHandle
implements ConcreteWebSocketEndPoint {
    private static final ScheduledExecutorService scheduledExecutorService = ExecutorsHelper.newScheduledThreadPool((int)1);
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerHandle.class);
    private static final Map<Session, String> peers = Collections.synchronizedMap(new HashMap());
    private final Map<String, WebSocketUnit> unitMap = new HashMap<String, WebSocketUnit>();
    private ThreadLocal<Class> context = new ThreadLocal();

    @Deprecated
    public WebSocketServerHandle(String endPoint) {
        this.registerPackage(ErrorCodes.class.getPackage().getName());
    }

    public WebSocketServerHandle() {
        this.registerPackage(ErrorCodes.class.getPackage().getName());
    }

    public void onOpen(Session peer) {
        if (!peers.containsKey(peer)) {
            peers.put(peer, Common.getUUIDStr());
        }
        peer.setMaxIdleTimeout(0L);
        log.debug("session opened: {}, concrete token id: {}, total sessions: {}", new Object[]{peer, peers.get(peer), peers.size()});
    }

    public void onClose(Session peer) {
        peers.remove(peer);
        log.debug("session closed: {}, total sessions: {}", (Object)peer, (Object)peers.size());
    }

    @Deprecated
    public <T> void broadcast(String subject, T content) {
        this.broadcast(subject, content, null, null);
    }

    @Deprecated
    public <T> void broadcast(String subject, T content, Map<String, String> subjoin) {
        this.broadcast(subject, content, subjoin, null);
    }

    @Deprecated
    public <T> void broadcast(String subject, T content, SessionFilter sessionFilter) {
        this.broadcast(subject, content, null, sessionFilter);
    }

    @Deprecated
    public <T> void broadcast(String subject, T content, Map<String, String> subjoin, SessionFilter sessionFilter) {
        String text = JSONSerializerFactory.getInstance().toJson((Object)this.buildPackage(subject, content, subjoin));
        for (Session session : peers.keySet()) {
            if (sessionFilter != null && sessionFilter.filter(session) == null) continue;
            this.broadcastText(text, session);
        }
    }

    private void broadcastText(String text, Session session) {
        log.debug("broadcast, async send to {}:\n{}", (Object)session.getId(), (Object)text);
        this.$sendText(text, session);
    }

    private void $sendText(String text, Session session) {
        WebSocketServerHandle.$sendText(text, session, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void $sendText(final String text, final Session session, AtomicInteger retry) {
        AtomicInteger toRetry;
        AtomicInteger atomicInteger = toRetry = retry == null ? new AtomicInteger(0) : retry;
        if (toRetry.get() >= 5) {
            log.warn("send text failed after retry 5 times. sessionId: {}, text: {}", (Object)session.getId(), (Object)text);
            return;
        }
        try {
            Session session2 = session;
            synchronized (session2) {
                session.getBasicRemote().sendText(text);
            }
        }
        catch (IOException | IllegalStateException e) {
            log.warn("send text failed. session: {}", (Object)session.getId(), (Object)e);
            scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    toRetry.incrementAndGet();
                    WebSocketServerHandle.$sendText(text, session, toRetry);
                }
            }, 20L, TimeUnit.MILLISECONDS);
        }
    }

    private void sendText(String text, Session session) {
        log.debug("async send to {}:\n{}", (Object)session.getId(), (Object)text);
        this.$sendText(text, session);
    }

    static <T> void sendMessage(Message<T> message, String tokenId) {
        for (Session session : peers.keySet()) {
            if (!tokenId.equals(peers.get(session))) continue;
            WebSocketServerHandle.$sendText(JSONSerializerFactory.getInstance().toJson(WebSocketServerHandle.buildPackage(message)), session, null);
            break;
        }
    }

    private void sendError(String msgId, ConcreteException exception, Session session) {
        ResponsePackage responsePackage = new ResponsePackage();
        responsePackage.setOk(false);
        responsePackage.setMsgId(msgId);
        responsePackage.setContent((Object)new ErrorInfo(exception));
        this.sendText(JSONSerializerFactory.getInstance().toJson((Object)responsePackage), session);
    }

    private static <T> ResponsePackage<T> buildPackage(Message<T> message) {
        ResponsePackage responsePackage = new ResponsePackage();
        HashMap<String, String> subjoin = new HashMap<String, String>();
        subjoin.put("broadcast", "true");
        subjoin.put("hostId", message.getHost());
        subjoin.put("subject", message.getSubject());
        responsePackage.setSubjoin(subjoin);
        responsePackage.setContent(message.getBody());
        responsePackage.setMsgId(message.getId());
        return responsePackage;
    }

    private <T> ResponsePackage buildPackage(String subject, T content, Map<String, String> subjoin) {
        if (subjoin == null) {
            subjoin = new HashMap<String, String>();
        }
        subjoin.put("broadcast", "true");
        subjoin.put("hostId", this.getHostId());
        subjoin.put("subject", subject);
        ResponsePackage responsePackage = new ResponsePackage();
        responsePackage.setSubjoin(new HashMap<String, String>(subjoin));
        if (content != null) {
            responsePackage.setContent(content);
        }
        return responsePackage;
    }

    public final void registerPackage(String ... packages) {
        ConcreteHelper.foreachClassInPackages((ReflectHelper.Processor)new ReflectHelper.Processor(){

            public void process(Class<?> serviceClass) {
                WebSocketServerHandle.this.registerClasses(serviceClass);
            }
        }, (String[])packages);
    }

    public final void registerClasses(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            if (AbstractErrorCodes.class.isAssignableFrom(clz)) {
                ErrorMessageFacade.register((Class[])new Class[]{clz});
                continue;
            }
            if (ConcreteHelper.isConcreteService(clz)) {
                this.appendUnits(new WebSocketModule(clz));
                continue;
            }
            throw new RuntimeException("cannot register class:" + clz.getName());
        }
    }

    public final void registerService(Class<? extends ConcreteService> ... serviceClasses) {
        for (Class<? extends ConcreteService> clz : serviceClasses) {
            if (!ConcreteHelper.isConcreteService(clz)) continue;
            this.appendUnits(new WebSocketModule(clz));
        }
    }

    private void appendUnits(WebSocketModule module) {
        for (WebSocketUnit unit : (WebSocketUnit[])module.getUnits()) {
            this.unitMap.put(unit.getKey(), unit);
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) throws IOException {
        log.debug("message from {}:\n {}", (Object)session.getId(), (Object)message);
        RequestPackage<Object> requestPackage = this.analysisRequest(message, session);
        if (requestPackage == null) {
            return;
        }
        try {
            this.invokeService(requestPackage, session);
        }
        catch (Throwable th) {
            this.sendError(requestPackage.getMsgId(), ConcreteHelper.getException((Throwable)th), session);
        }
    }

    private synchronized Token getToken(Session session, RequestPackage requestPackage) {
        Token token = ((TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class)).getToken(peers.get(session), false);
        peers.put(session, token == null ? null : token.getTokenId());
        return token;
    }

    private void invokeService(final RequestPackage<Object> requestPackage, final Session session) {
        final WebSocketUnit unit = (WebSocketUnit)IF.isNull((Object)this.unitMap.get(requestPackage.getServiceId()), (int)4001, (Object[])new Object[]{requestPackage.getServiceId()});
        final Object[] objects = this.analysisParameters(JSONSerializerFactory.getInstance().toJson(requestPackage.getContent()), unit);
        Token t = this.getToken(session, requestPackage);
        final boolean isNew = t == null;
        final Token token = t == null ? ((TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class)).getToken(Common.getUUIDStr(), true) : t;
        peers.put(session, token.getTokenId());
        ConcreteHelper.getExecutor().execute((Runnable)new PriorityRunnable(ConcreteHelper.getPriority((AbstractUnit)unit), new Runnable(){
            private Method method;
            {
                this.method = unit.getMethod();
            }

            @Override
            public void run() {
                WebSocketServiceContext context = new WebSocketServiceContext(token, this.getSubjoin(requestPackage.getSubjoin()), (AbstractUnit)unit, (Caller)session.getUserProperties().get(CallerHackConfigurator.WEB_SOCKET_CALLER_INFO));
                try {
                    Object result = ConcreteContext.runWithContext((ServiceContext)context, (CallableClosure)new CallableClosure(){

                        public Object call() throws Throwable {
                            if (ConcreteHelper.isDevModel((String)"websocket")) {
                                return Void.TYPE.equals(unit.getGenericReturnType()) ? null : MockerFacade.mock((Method)unit.getMethod(), (Class[])new Class[]{((WebSocketModule)unit.getDeclaringModule()).getInterfaceClass()});
                            }
                            Object instance = BeanProviderFacade.getBeanProvider().getBean(((WebSocketModule)unit.getDeclaringModule()).getInterfaceClass());
                            if (objects == null) {
                                return method.invoke(instance, new Object[0]);
                            }
                            return method.invoke(instance, objects);
                        }
                    });
                    ResponsePackage responsePackage = new ResponsePackage();
                    if (isNew) {
                        responsePackage.setConcreteTokenId(token.getTokenId());
                    }
                    responsePackage.setMsgId(requestPackage.getMsgId());
                    responsePackage.setOk(true);
                    responsePackage.setContent(result);
                    WebSocketServerHandle.this.sendText(JSONSerializerFactory.getInstance().toJson((Object)responsePackage), session);
                }
                catch (Throwable th) {
                    ConcreteContext.runWithContext((ServiceContext)context, (CallableClosure)new CallableClosure(){

                        public Object call() throws Throwable {
                            WebSocketServerHandle.this.sendError(requestPackage.getMsgId(), ConcreteHelper.getException((Throwable)th), session);
                            return null;
                        }
                    });
                }
            }

            private Subjoin getSubjoin(Map<String, String> map) {
                return new WebSocketSubjoin(map);
            }
        }));
    }

    private Type paramType(AbstractParam param) {
        return TypeHelper.isPrimitive((Class)param.getType()) ? param.getType() : TypeHelper.toTypeReference((Type)param.getGenericType(), (Type[])new Type[]{this.context.get()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] analysisParameters(String content, WebSocketUnit unit) {
        AbstractParam[] abstractParams = unit.getParameters();
        if (abstractParams.length == 0) {
            return null;
        }
        this.context.set(((WebSocketModule)unit.getDeclaringModule()).getInterfaceClass());
        try {
            JSONSerializer serializer = JSONSerializerFactory.getInstance();
            ArrayList<Object> objects = new ArrayList<Object>();
            if (abstractParams.length == 1) {
                objects.add(content == null ? null : serializer.parse(content, this.paramType(abstractParams[0])));
            } else {
                Map map = (Map)serializer.parse(content, new GenericType<Map<String, String>>(){}.genericType());
                for (AbstractParam param : abstractParams) {
                    String value = (String)map.get(param.getName());
                    objects.add(value == null ? null : serializer.parse(value, this.paramType(param)));
                }
            }
            Object[] objectArray = objects.toArray();
            return objectArray;
        }
        finally {
            this.context.remove();
        }
    }

    private RequestPackage<Object> analysisRequest(String message, Session session) {
        try {
            return (RequestPackage)JSONSerializerFactory.getInstance().parse(message, new GenericType<RequestPackage<Object>>(){}.genericType());
        }
        catch (Throwable throwable) {
            this.broadcastText(JSONSerializerFactory.getInstance().toJson((Object)this.buildPackage("INVALID_REQUEST", new InvalidRequest(ConcreteHelper.getException((Throwable)throwable), message), null)), session);
            return null;
        }
    }

    public String getHostId() {
        return ConcreteHelper.getProfile().getString("websocket.hostId", Common.getUUIDStr());
    }
}

