/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.test;

import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.local.LocalTokenManager;
import org.coodex.concrete.test.TokenID;
import org.coodex.util.Common;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreteTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(ConcreteTokenProvider.class);
    private static final TokenManager TOKEN_MANAGER_INSTANCE = ConcreteTokenProvider.getInstance();

    private static TokenManager getInstance() {
        try {
            return (TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class);
        }
        catch (ConcreteException ex) {
            log.warn("error occurred: {}. Using LocalTokenManager", (Object)ex.getLocalizedMessage());
            return new LocalTokenManager();
        }
    }

    public static Token getToken(String id) {
        return TOKEN_MANAGER_INSTANCE.getToken(Common.isBlank((String)id) ? Common.getUUIDStr() : id, true);
    }

    public static Token getToken(Description description) {
        TokenID testToken = (TokenID)description.getAnnotation(TokenID.class);
        return ConcreteTokenProvider.getToken(testToken == null ? null : testToken.value());
    }
}

