/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.test;

import java.util.Arrays;
import java.util.Collection;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.common.AbstractSubjoin;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.test.TestServiceContext;
import org.coodex.concrete.test.TestSubjoin;
import org.coodex.concrete.test.TestSubjoinItem;
import org.coodex.concrete.test.TokenID;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConcreteTestRule
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TokenID testToken = (TokenID)description.getAnnotation(TokenID.class);
                String tokenId = testToken == null ? null : testToken.value();
                try {
                    ConcreteContext.runWithContext((ServiceContext)new TestServiceContext(tokenId, ConcreteTestRule.this.getSubjoin(description)), (CallableClosure)new CallableClosure(){

                        public Object call() throws Throwable {
                            base.evaluate();
                            return null;
                        }
                    });
                }
                catch (ConcreteException ce) {
                    throw ce.getCause() != null && ce.getCode() == 99999 ? ce.getCause() : ce;
                }
            }
        };
    }

    private Subjoin getSubjoin(Description description) {
        AbstractSubjoin subjoin = new AbstractSubjoin(){

            protected Collection<String> skipKeys() {
                return null;
            }
        };
        TestSubjoin testSubjoin = (TestSubjoin)description.getAnnotation(TestSubjoin.class);
        if (testSubjoin != null && testSubjoin.value().length > 0) {
            for (TestSubjoinItem testSubjoinItem : testSubjoin.value()) {
                subjoin.set(testSubjoinItem.key(), Arrays.asList(testSubjoinItem.value()));
            }
        }
        return subjoin;
    }
}

