/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.websocket.client;

import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.client.ClientCommon;
import org.coodex.concrete.client.MessageSubscriber;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteClosure;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.struct.AbstractParam;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.core.intercept.AsyncInterceptorChain;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.websocket.BroadcastListener;
import org.coodex.concrete.websocket.RequestPackage;
import org.coodex.concrete.websocket.ResponsePackage;
import org.coodex.concrete.websocket.WebSocket;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.concrete.websocket.WebSocketSubjoin;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.concrete.websocket.client.AsyncMethodInvocation;
import org.coodex.concrete.websocket.client.SetUserAgentConfigurator;
import org.coodex.concrete.websocket.client.WebSocketCallback;
import org.coodex.concrete.websocket.client.WebSocketClientException;
import org.coodex.concrete.websocket.client.WebSocketClientServiceContext;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Common;
import org.coodex.util.GenericType;
import org.coodex.util.ServiceLoaderFacade;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(configurator=SetUserAgentConfigurator.class)
public class WebSocketClientHandle {
    private static final WebSocketClientHandle handler = new WebSocketClientHandle();
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientHandle.class);
    private Map<String, WebSocketUnit> unitMap = new HashMap<String, WebSocketUnit>();
    private Set<Class> loaded = new HashSet<Class>();
    private Map<String, WebSocketCallback> callbackMap = new HashMap<String, WebSocketCallback>();
    private Map<String, Session> sessionMap = new HashMap<String, Session>();
    private Map<String, Map<String, String>> subjoinMap = new HashMap<String, Map<String, String>>();
    private static ScheduledExecutorService scheduledExecutorService = ExecutorsHelper.newScheduledThreadPool((int)1);
    @Deprecated
    private static final AcceptableServiceLoader<String, BroadcastListener> listenerLoader = new AcceptableServiceLoader((ServiceLoaderFacade)new ConcreteServiceLoader<BroadcastListener>(){});
    private static AsyncInterceptorChain asyncInterceptorChain;

    public static WebSocketClientHandle getInstance() {
        return handler;
    }

    private WebSocketClientHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObservableOnSubscribe buildObservable(final String domain, final String tokenManagerKey, final Class serviceClass, final Method method, final Object[] args) {
        WebSocketClientHandle webSocketClientHandle = this;
        synchronized (webSocketClientHandle) {
            if (!this.loaded.contains(serviceClass)) {
                WebSocketModule webSocketModule = new WebSocketModule(serviceClass);
                for (WebSocketUnit unit : (WebSocketUnit[])webSocketModule.getUnits()) {
                    this.unitMap.put(unit.getKey(), unit);
                }
                this.loaded.add(serviceClass);
            }
        }
        String unitKey = this.buildKey(serviceClass, method);
        final WebSocketUnit unit = this.unitMap.get(unitKey);
        return new ObservableOnSubscribe(){

            public void subscribe(ObservableEmitter e) throws Exception {
                try {
                    Assert.isNull((Object)unit, (int)4003, (Object[])new Object[]{WebSocketClientHandle.this.keyBase(serviceClass, method)});
                    final Session session = (Session)Assert.isNull((Object)WebSocketClientHandle.this.getSession(domain), (int)4002, (Object[])new Object[]{domain});
                    final String msgId = Common.getUUIDStr();
                    final String tokenKey = Common.isBlank((String)tokenManagerKey) ? domain : tokenManagerKey;
                    final RequestPackage requestPackage = WebSocketClientHandle.this.buildRequest(msgId, unit, args);
                    final WebSocketCallback callback = WebSocketClientHandle.this.registerCallback(msgId, tokenKey, unit, e, WebSocketClientHandle.toRuntimeContext(unit), new AsyncMethodInvocation(unit.getMethod(), args));
                    try {
                        ConcreteContext.runWithContext((ServiceContext)new WebSocketClientServiceContext((AbstractUnit)callback.getUnit(), (Subjoin)new WebSocketSubjoin(WebSocketClientHandle.this.getSubjoin(domain))), (ConcreteClosure)new ConcreteClosure(){

                            public Object concreteRun() throws Throwable {
                                WebSocketClientHandle.getInterceptorChain().before(callback.getContext(), callback.getInvocation());
                                if (!Common.isBlank((String)ClientCommon.getTokenId((String)tokenKey))) {
                                    requestPackage.setConcreteTokenId(ClientCommon.getTokenId((String)tokenKey));
                                }
                                requestPackage.setSubjoin(((WebSocketSubjoin)ConcreteContext.getServiceContext().getSubjoin()).toMap());
                                if (ConcreteHelper.isDevModel((String)"websocket.client")) {
                                    final ResponsePackage responsePackage = new ResponsePackage();
                                    responsePackage.setMsgId(msgId);
                                    responsePackage.setOk(true);
                                    responsePackage.setContent(Void.TYPE.equals(unit.getGenericReturnType()) ? null : MockerFacade.mock((Method)unit.getMethod(), (Class[])new Class[]{((WebSocketModule)unit.getDeclaringModule()).getInterfaceClass()}));
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            try {
                                                WebSocketClientHandle.this.onMessage(JSONSerializerFactory.getInstance().toJson((Object)responsePackage), session);
                                            }
                                            catch (IOException e1) {
                                                throw new RuntimeException(e1.getLocalizedMessage(), e1);
                                            }
                                        }
                                    }.start();
                                } else {
                                    WebSocketClientHandle.this.sendRequest(requestPackage, session);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Throwable th) {
                        WebSocketClientHandle.this.callbackMap.remove(msgId);
                        callback.getFuture().cancel(true);
                        throw th;
                    }
                }
                catch (Throwable th) {
                    e.onError((Throwable)ConcreteHelper.getException((Throwable)th));
                }
            }
        };
    }

    private static RuntimeContext toRuntimeContext(WebSocketUnit unit) {
        return RuntimeContext.getRuntimeContext((Method)unit.getMethod(), (Class)((WebSocketModule)unit.getDeclaringModule()).getInterfaceClass());
    }

    private WebSocketCallback registerCallback(final String msgId, String tokenManagerKey, WebSocketUnit unit, final ObservableEmitter e, RuntimeContext context, MethodInvocation invocation) {
        WebSocketCallback webSocketCallback = new WebSocketCallback(msgId, tokenManagerKey, unit, scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                WebSocketClientHandle.this.callbackMap.remove(msgId);
                e.onError((Throwable)new ConcreteException(4004, new Object[0]));
            }
        }, 15L, TimeUnit.MINUTES), e, context, invocation);
        this.callbackMap.put(msgId, webSocketCallback);
        return webSocketCallback;
    }

    private RequestPackage buildRequest(String msgId, WebSocketUnit unit, Object[] args) {
        RequestPackage requestPackage = new RequestPackage();
        requestPackage.setMsgId(msgId);
        requestPackage.setServiceId(unit.getKey());
        AbstractParam[] parameters = unit.getParameters();
        switch (parameters.length) {
            case 0: {
                break;
            }
            case 1: {
                requestPackage.setContent(args[0]);
                break;
            }
            default: {
                HashMap<String, Object> toSend = new HashMap<String, Object>();
                for (int i = 0; i < parameters.length; ++i) {
                    toSend.put(parameters[i].getName(), args[i]);
                }
                requestPackage.setContent(toSend);
            }
        }
        return requestPackage;
    }

    private String toJson(Object o) {
        return JSONSerializerFactory.getInstance().toJson(o);
    }

    private void sendRequest(RequestPackage requestPackage, Session session) {
        String content = this.toJson(requestPackage);
        log.debug("session {} send message:\n{}", (Object)session.getId(), (Object)content);
        session.getAsyncRemote().sendText(content);
    }

    private Map<String, String> getSubjoin(String domain) {
        return this.subjoinMap.get(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(String domain) throws InterruptedException, URISyntaxException, IOException, DeploymentException {
        Map<String, Session> map = this.sessionMap;
        synchronized (map) {
            Session session = this.sessionMap.get(domain);
            if (session == null || !session.isOpen()) {
                WebSocketContainer container = ContainerProvider.getWebSocketContainer();
                session = container.connectToServer((Object)this, new URI(domain));
                session.setMaxIdleTimeout(0L);
                this.sessionMap.put(domain, session);
            }
            int maxRetryTimes = 10;
            int retried = 0;
            while (!session.isOpen() && retried++ < maxRetryTimes) {
                Thread.sleep(100L);
            }
            if (!session.isOpen()) {
                this.sessionMap.remove(domain);
                return null;
            }
            return session;
        }
    }

    private String keyBase(Class serviceClass, Method method) {
        return String.format("%s:%s(%d)", serviceClass.getName(), method.getName(), method.getParameterTypes().length);
    }

    private String buildKey(Class serviceClass, Method method) {
        return Common.sha1((String)this.keyBase(serviceClass, method));
    }

    @OnClose
    public void onClose(Session session) throws IOException {
        log.debug("session {} closed.", (Object)session.getId());
    }

    @OnMessage
    public void onMessage(String message, Session session) throws IOException {
        log.debug("session {} received msg : \n{}", (Object)session.getId(), (Object)message);
        ResponsePackage responsePackage = (ResponsePackage)JSONSerializerFactory.getInstance().parse(message, new GenericType<ResponsePackage<Object>>(){}.genericType());
        Map subjoin = responsePackage.getSubjoin();
        if (subjoin != null) {
            // empty if block
        }
        if (subjoin == null || !"true".equals(subjoin.get("broadcast"))) {
            this.onReturn((ResponsePackage<Object>)responsePackage, session);
        } else {
            this.onBroadcast((ResponsePackage<Object>)responsePackage, session);
        }
    }

    private void onReturn(ResponsePackage<Object> responsePackage, Session session) {
        final WebSocketCallback callback = this.callbackMap.get(responsePackage.getMsgId());
        if (callback == null) {
            log.warn("cannot found callback for {}", (Object)responsePackage.getMsgId());
            return;
        }
        this.callbackMap.remove(responsePackage.getMsgId());
        callback.getFuture().cancel(true);
        try {
            Object result = null;
            if (!Common.isBlank((String)responsePackage.getConcreteTokenId())) {
                ClientCommon.setTokenId((String)callback.getTokenManagerKey(), (String)responsePackage.getConcreteTokenId());
            }
            if (!responsePackage.isOk()) {
                throw new WebSocketClientException((ErrorInfo)JSONSerializerFactory.getInstance().parse(responsePackage.getContent(), ErrorInfo.class));
            }
            if (responsePackage.getContent() != null) {
                result = JSONSerializerFactory.getInstance().parse(responsePackage.getContent(), TypeHelper.toTypeReference((Type)callback.getUnit().getGenericReturnType(), (Type[])new Type[]{((WebSocketModule)callback.getUnit().getDeclaringModule()).getInterfaceClass()}));
            }
            final Object o = result;
            ConcreteContext.runWithContext((ServiceContext)new WebSocketClientServiceContext((AbstractUnit)callback.getUnit(), (Subjoin)new WebSocketSubjoin(responsePackage.getSubjoin())), (ConcreteClosure)new ConcreteClosure(){

                public Object concreteRun() throws Throwable {
                    Object r = o;
                    r = WebSocketClientHandle.getInterceptorChain().after(callback.getContext(), callback.getInvocation(), r);
                    if (r != null) {
                        callback.getEmitter().onNext(r);
                    }
                    callback.getEmitter().onComplete();
                    return null;
                }
            });
        }
        catch (Throwable th) {
            callback.getEmitter().onError((Throwable)ConcreteHelper.getException((Throwable)th));
        }
    }

    @Deprecated
    private boolean handleBroadcast(BroadcastListener listener, ResponsePackage<Object> responsePackage) {
        try {
            String subject = (String)responsePackage.getSubjoin().get("subject");
            if (listener.accept((Object)subject)) {
                listener.onBroadcast(responsePackage.getMsgId(), (String)responsePackage.getSubjoin().get("hostId"), subject, this.toJson(responsePackage.getContent()));
                return true;
            }
        }
        catch (Throwable th) {
            log.warn("{}", (Object)th.getLocalizedMessage(), (Object)th);
        }
        return false;
    }

    private void onBroadcast(ResponsePackage<Object> responsePackage, Session session) {
        MessageSubscriber.next((String)((String)responsePackage.getSubjoin().get("subject")), (String)this.toJson(responsePackage.getContent()));
    }

    private static synchronized AsyncInterceptorChain getInterceptorChain() {
        if (asyncInterceptorChain == null) {
            ConcreteServiceLoader<ConcreteInterceptor> spiFacade = new ConcreteServiceLoader<ConcreteInterceptor>(){};
            asyncInterceptorChain = new AsyncInterceptorChain();
            for (ConcreteInterceptor interceptor : spiFacade.getAllInstances()) {
                asyncInterceptorChain.add(interceptor);
            }
        }
        return asyncInterceptorChain;
    }

    @Deprecated
    private static class Client
    extends WebSocket {
        private Client() {
        }

        static Set<BroadcastListener> getRegisteredListeners() {
            return Client.getListeners();
        }
    }
}

