/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.websocket.client;

import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.coodex.concrete.client.ClientCommon;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.rx.RXClientProvider;
import org.coodex.concrete.rx.ReactiveExtensionFor;
import org.coodex.concrete.websocket.client.WebSocketClientHandle;

public class WebSocketClientProvider
implements RXClientProvider {
    public <T> T getInstance(Class<T> clz, final ClientCommon.Domain domain, final String tokenManagerKey) {
        try {
            final Class serviceClass = clz.getAnnotation(ReactiveExtensionFor.class).value();
            return (T)Proxy.newProxyInstance(WebSocketClientProvider.class.getClassLoader(), new Class[]{clz}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return Observable.create((ObservableOnSubscribe)WebSocketClientHandle.getInstance().buildObservable(domain.getIdentify(), tokenManagerKey, serviceClass, method, args));
                }
            });
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    public boolean accept(ClientCommon.Domain param) {
        String host = param.getIdentify().toLowerCase();
        return host.startsWith("ws://") || host.startsWith("wss://");
    }
}

