/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.websocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.websocket.SetUserAgentConfigurator;
import org.coodex.concrete.client.websocket.WSClientException;
import org.coodex.concrete.client.websocket.WSInvokerFactory;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.websocket.RequestPackage;
import org.coodex.concrete.websocket.ResponsePackage;
import org.coodex.concurrent.TimeLimitedMap;
import org.coodex.util.GenericType;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(configurator=SetUserAgentConfigurator.class)
public class WSClientHandle {
    private static final Logger log = LoggerFactory.getLogger(WSClientHandle.class);
    private TimeLimitedMap<String, WSCallback> callbackMap = new TimeLimitedMap();
    private Map<Destination, Session> sessionMap = new HashMap<Destination, Session>();
    private JSONSerializer serializer = JSONSerializerFactory.getInstance();
    private SingletonMap<Destination, Object> locks = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<Destination, Object>(){

        public Object build(Destination key) {
            return new Object();
        }
    });

    WSClientHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(Destination destination) throws URISyntaxException, IOException, DeploymentException, InterruptedException {
        Session session = this.sessionMap.get(destination);
        if (session == null || !session.isOpen()) {
            Object lock;
            Object object = lock = this.locks.getInstance((Object)destination);
            synchronized (object) {
                session = this.sessionMap.get(destination);
                if (session == null || !session.isOpen()) {
                    WebSocketContainer container = ContainerProvider.getWebSocketContainer();
                    if (WSInvokerFactory.isSSL(destination.getLocation())) {
                        // empty if block
                    }
                    session = container.connectToServer((Object)this, new URI(destination.getLocation()));
                    session.setMaxIdleTimeout(0L);
                    this.sessionMap.put(destination, session);
                    int maxRetryTimes = 10;
                    int retried = 0;
                    while (!session.isOpen() && retried++ < maxRetryTimes) {
                        Thread.sleep(100L);
                    }
                    if (!session.isOpen()) {
                        this.sessionMap.remove(destination);
                        throw new IOException("Cannot open websocket session: " + destination.getLocation());
                    }
                    log.debug("session opened. " + session.getId() + ". " + destination);
                }
            }
        }
        return session;
    }

    @OnMessage
    public void onMessage(String message, Session session) throws IOException {
        ResponsePackage responsePackage = (ResponsePackage)this.serializer.parse(message, new GenericType<ResponsePackage<Object>>(){}.genericType());
        WSCallback callback = (WSCallback)this.callbackMap.getAndRemove((Object)responsePackage.getMsgId());
        if (callback != null) {
            if (responsePackage.isOk()) {
                callback.onReturn((ResponsePackage<Object>)responsePackage);
            } else {
                callback.onError((Throwable)((Object)new WSClientException((ErrorInfo)this.serializer.parse(responsePackage.getContent(), ErrorInfo.class))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(final Destination destination, final RequestPackage requestPackage, final WSCallback callback) {
        try {
            Session session;
            Session session2 = session = this.getSession(destination);
            synchronized (session2) {
                block7: {
                    this.callbackMap.put((Object)requestPackage.getMsgId(), (Object)callback, new TimeLimitedMap.TimeoutCallback(){

                        public void timeout() {
                            callback.onError(new TimeoutException("request timeout: " + requestPackage.getServiceId() + " " + destination.toString()));
                        }
                    });
                    try {
                        session.getBasicRemote().sendText(this.serializer.toJson((Object)requestPackage));
                    }
                    catch (Throwable th) {
                        if (this.callbackMap.getAndRemove((Object)requestPackage.getMsgId()) == null) break block7;
                        callback.onError((Throwable)ConcreteHelper.getException((Throwable)th));
                    }
                }
            }
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    public static interface WSCallback {
        public void onReturn(ResponsePackage<Object> var1);

        public void onError(Throwable var1);
    }
}

