/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.websocket;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.coodex.concrete.client.ClientServiceContext;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.concrete.websocket.WebSocketUnit;

public class WSClientServiceContext
extends ClientServiceContext {
    private static Map<Class, WebSocketModule> moduleMap = new ConcurrentHashMap<Class, WebSocketModule>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WebSocketModule getModule(Class concreteClass) {
        if (!moduleMap.containsKey(concreteClass)) {
            Map<Class, WebSocketModule> map = moduleMap;
            synchronized (map) {
                if (!moduleMap.containsKey(concreteClass)) {
                    moduleMap.put(concreteClass, new WebSocketModule(concreteClass));
                }
            }
        }
        return moduleMap.get(concreteClass);
    }

    static WebSocketUnit findUnit(RuntimeContext context) {
        WebSocketModule module = (WebSocketModule)IF.isNull((Object)WSClientServiceContext.getModule(context.getDeclaringClass()), (String)(context.getDeclaringClass() + "is not a concrete service."));
        Method method = context.getDeclaringMethod();
        for (WebSocketUnit unit : (WebSocketUnit[])module.getUnits()) {
            if (!unit.getMethod().getName().equals(method.getName()) || !Arrays.equals(unit.getMethod().getParameterTypes(), method.getParameterTypes())) continue;
            return unit;
        }
        throw new RuntimeException("unable found websocket unit: " + context.getDeclaringClass().getName() + " " + context.getDeclaringMethod().getName());
    }

    public WSClientServiceContext(Destination destination, RuntimeContext context) {
        super(destination, context);
        this.model = "web_socket_model";
    }

    protected AbstractUnit getUnit(RuntimeContext context) {
        return WSClientServiceContext.findUnit(context);
    }
}

