/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.websocket;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.rx.AbstractRxInvoker;
import org.coodex.concrete.client.websocket.WSClientHandle;
import org.coodex.concrete.client.websocket.WSClientServiceContext;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.websocket.RequestPackage;
import org.coodex.concrete.websocket.ResponsePackage;
import org.coodex.concrete.websocket.WebSocketHelper;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.coodex.util.TypeHelper;

public class WSInvoker
extends AbstractRxInvoker {
    private static Singleton<WSClientHandle> handle = new Singleton((Singleton.Builder)new Singleton.Builder<WSClientHandle>(){

        public WSClientHandle build() {
            return new WSClientHandle();
        }
    });
    private JSONSerializer serializer = JSONSerializerFactory.getInstance();

    WSInvoker(Destination destination) {
        super(destination);
    }

    public ServiceContext buildContext(Class concreteClass, Method method) {
        return new WSClientServiceContext(this.getDestination(), RuntimeContext.getRuntimeContext((Method)method, (Class)concreteClass));
    }

    private WSClientServiceContext getContext() {
        ServiceContext context = ConcreteContext.getServiceContext();
        if (context instanceof WSClientServiceContext) {
            return (WSClientServiceContext)context;
        }
        throw new RuntimeException("context [" + context + "] is NOT WSClientServiceContext");
    }

    public Observable invoke(final RuntimeContext context, final Object ... args) {
        final WSClientServiceContext wsClientServiceContext = this.getContext();
        final WebSocketUnit unit = WebSocketHelper.findUnit((RuntimeContext)context);
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

            public void subscribe(final ObservableEmitter emitter) throws Exception {
                String msgId = Common.getUUIDStr();
                RequestPackage requestPackage = WebSocketHelper.buildRequest((String)msgId, (WebSocketUnit)unit, (Object[])args);
                requestPackage.setConcreteTokenId(ClientTokenManagement.getTokenId((Destination)WSInvoker.this.getDestination(), (String)wsClientServiceContext.getTokenId()));
                try {
                    ((WSClientHandle)handle.getInstance()).send(WSInvoker.this.getDestination(), requestPackage, new WSClientHandle.WSCallback(){
                        private boolean completed = false;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void complete() {
                            if (!this.completed) {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    if (!this.completed) {
                                        emitter.onComplete();
                                        this.completed = true;
                                    }
                                }
                            }
                        }

                        @Override
                        public void onReturn(ResponsePackage<Object> responsePackage) {
                            try {
                                ClientTokenManagement.setTokenId((Destination)WSInvoker.this.getDestination(), (String)responsePackage.getConcreteTokenId());
                                if (responsePackage.getContent() == null || Void.TYPE.equals(context.getDeclaringMethod().getReturnType())) {
                                    emitter.onNext(null);
                                } else {
                                    emitter.onNext(WSInvoker.this.serializer.parse(responsePackage.getContent(), TypeHelper.toTypeReference((Type)context.getDeclaringMethod().getGenericReturnType(), (Type[])new Type[]{context.getDeclaringClass()})));
                                }
                            }
                            catch (Throwable throwable) {
                                emitter.onError(throwable);
                            }
                            finally {
                                this.complete();
                            }
                        }

                        @Override
                        public void onError(Throwable th) {
                            try {
                                emitter.onError(th);
                            }
                            finally {
                                this.complete();
                            }
                        }
                    });
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    emitter.onError(th);
                    emitter.onComplete();
                }
            }
        });
    }
}

