/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.websocket;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.struct.AbstractParam;
import org.coodex.concrete.websocket.RequestPackage;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.util.Common;

public class WebSocketHelper {
    private static String keyBase(Class serviceClass, Method method) {
        return String.format("%s:%s(%d)", serviceClass.getName(), method.getName(), method.getParameterTypes().length);
    }

    public static String buildKey(Class serviceClass, Method method) {
        return Common.sha1((String)WebSocketHelper.keyBase(serviceClass, method));
    }

    private static String buildKey(RuntimeContext runtimeContext) {
        return WebSocketHelper.buildKey(runtimeContext.getDeclaringClass(), runtimeContext.getDeclaringMethod());
    }

    public static RequestPackage buildRequest(String msgId, WebSocketUnit unit, Object[] args) {
        RequestPackage<Object> requestPackage = new RequestPackage<Object>();
        requestPackage.setMsgId(msgId);
        requestPackage.setServiceId(unit.getKey());
        AbstractParam[] parameters = unit.getParameters();
        switch (parameters.length) {
            case 0: {
                break;
            }
            case 1: {
                requestPackage.setContent(args[0]);
                break;
            }
            default: {
                HashMap<String, Object> toSend = new HashMap<String, Object>();
                for (int i = 0; i < parameters.length; ++i) {
                    toSend.put(parameters[i].getName(), args[i]);
                }
                requestPackage.setContent(toSend);
            }
        }
        return requestPackage;
    }
}

