/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.websocket;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.struct.AbstractParam;
import org.coodex.concrete.websocket.RequestPackage;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;

public class WebSocketHelper {
    private static SingletonMap<Class, WebSocketModule> modules = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<Class, WebSocketModule>(){

        public WebSocketModule build(Class key) {
            return new WebSocketModule(key);
        }
    });

    private static String keyBase(Class serviceClass, Method method) {
        return String.format("%s:%s(%d)", serviceClass.getName(), method.getName(), method.getParameterTypes().length);
    }

    public static String buildKey(Class serviceClass, Method method) {
        return Common.sha1((String)WebSocketHelper.keyBase(serviceClass, method));
    }

    private static String buildKey(RuntimeContext runtimeContext) {
        return WebSocketHelper.buildKey(runtimeContext.getDeclaringClass(), runtimeContext.getDeclaringMethod());
    }

    public static RequestPackage buildRequest(String msgId, WebSocketUnit unit, Object[] args) {
        RequestPackage<Object> requestPackage = new RequestPackage<Object>();
        requestPackage.setMsgId(msgId);
        requestPackage.setServiceId(unit.getKey());
        AbstractParam[] parameters = unit.getParameters();
        switch (parameters.length) {
            case 0: {
                break;
            }
            case 1: {
                requestPackage.setContent(args[0]);
                break;
            }
            default: {
                HashMap<String, Object> toSend = new HashMap<String, Object>();
                for (int i = 0; i < parameters.length; ++i) {
                    toSend.put(parameters[i].getName(), args[i]);
                }
                requestPackage.setContent(toSend);
            }
        }
        return requestPackage;
    }

    public static WebSocketUnit findUnit(RuntimeContext context) {
        WebSocketModule module = (WebSocketModule)((Object)IF.isNull((Object)modules.getInstance((Object)context.getDeclaringClass()), (String)(context.getDeclaringClass() + "is not a concrete service.")));
        Method method = context.getDeclaringMethod();
        for (WebSocketUnit unit : (WebSocketUnit[])module.getUnits()) {
            if (!unit.getMethod().getName().equals(method.getName()) || !Arrays.equals(unit.getMethod().getParameterTypes(), method.getParameterTypes())) continue;
            return unit;
        }
        throw new RuntimeException("unable found websocket unit: " + context.getDeclaringClass().getName() + " " + context.getDeclaringMethod().getName());
    }
}

