/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts;

import org.coodex.concrete.accounts.Administrator;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.ClassifiableAccountFactory;
import org.coodex.concrete.common.ClassifiableAccountID;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;

public abstract class AbstractAdministratorFactory
extends ClassifiableAccountFactory {
    private Token token = TokenWrapper.getInstance();

    public Account<ClassifiableAccountID> getAccountByID(ClassifiableAccountID id) {
        if (id == null) {
            return null;
        }
        return this.getAdministrator(id.getId());
    }

    protected Integer[] getSupportTypes() {
        return new Integer[]{0};
    }

    public void login(String tenant, String id, String password, String authCode) {
        Administrator administrator = this.getAdministrator(id, tenant);
        if (!administrator.verify(password, authCode)) {
            throw new ConcreteException(10002, new Object[0]);
        }
        this.token.setAccount((Account)administrator);
        this.token.setAccountCredible(true);
    }

    protected abstract Administrator getAdministrator(String var1);

    protected abstract Administrator getAdministrator(String var1, String var2);
}

