/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts;

import java.io.Serializable;
import java.text.DateFormat;
import org.coodex.concrete.accounts.CanLoginEntity;
import org.coodex.concrete.accounts.PasswordGenerator;
import org.coodex.concrete.accounts.PasswordGeneratorImpl;
import org.coodex.concrete.accounts.TOTPAuthenticator;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DateFormatter;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.TenantBuilderWrapper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.config.Config;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;
import org.springframework.data.repository.CrudRepository;

public class AccountsCommon {
    private static final DateFormatter DEFAULT_DATE_FORMATTER = new DateFormatter(){

        public DateFormat getDateFormat() {
            return Common.getSafetyDateFormat((String)"yyyy-MM-dd");
        }

        public DateFormat getDateTimeFormat() {
            return Common.getSafetyDateFormat((String)"yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final ServiceLoader<DateFormatter> DATE_FORMATTER_SERVICE_LOADER = new LazyServiceLoader<DateFormatter>(DEFAULT_DATE_FORMATTER){};
    private static final PasswordGenerator DEFAULT_PASSWORD_GENERATOR = new PasswordGeneratorImpl();
    private static final String TAG_ACCOUNTS_SETTING = "concrete_accounts";
    private static final LazySelectableServiceLoader<String, PasswordGenerator> PASSWORD_GENERATORS = new LazySelectableServiceLoader<String, PasswordGenerator>(DEFAULT_PASSWORD_GENERATOR){};

    public static String getDefaultPassword() {
        return AccountsCommon.getEncodedPassword(null);
    }

    public static String getEncodedPassword(String pwd) {
        return ((PasswordGenerator)PASSWORD_GENERATORS.select((Object)"organization")).encode(pwd);
    }

    public static String getApplicationName() {
        return (String)Config.getValue((String)"application.name", (Object)"coodex.org", (String[])new String[]{TAG_ACCOUNTS_SETTING, ConcreteHelper.getAppSet()});
    }

    public static boolean getBool(String key, boolean defaultValue) {
        return (Boolean)Config.getValue((String)key, (Object)defaultValue, (String[])new String[]{TAG_ACCOUNTS_SETTING, ConcreteHelper.getAppSet()});
    }

    public static int getInt(String key, int defaultValue) {
        return (Integer)Config.getValue((String)key, (Object)defaultValue, (String[])new String[]{TAG_ACCOUNTS_SETTING, ConcreteHelper.getAppSet()});
    }

    public static String getString(String key) {
        return AccountsCommon.getString(key, null);
    }

    public static String getString(String key, String defaultValue) {
        return defaultValue == null ? Config.get((String)key, (String[])new String[]{TAG_ACCOUNTS_SETTING, ConcreteHelper.getAppSet()}) : (String)Config.getValue((String)key, (Object)defaultValue, (String[])new String[]{TAG_ACCOUNTS_SETTING, ConcreteHelper.getAppSet()});
    }

    public static String getTenant() {
        return TenantBuilderWrapper.getInstance().getTenant();
    }

    public static <E extends CanLoginEntity> E checkAuthCode(String authCode, E entity) {
        IF.isNull((Object)entity.getAuthCodeKeyActiveTime(), (int)10005, (Object[])new Object[0]);
        IF.not((boolean)TOTPAuthenticator.authenticate(authCode, entity.getAuthCodeKey()), (int)10004, (Object[])new Object[0]);
        return entity;
    }

    public static <E extends CanLoginEntity> void updatePassword(E entity, String password, String authCode, CrudRepository<E, String> repo) {
        AccountsCommon.checkAuthCode(authCode, entity);
        entity.setPassword(AccountsCommon.getEncodedPassword(password));
        repo.save(entity);
    }

    public static String getAuthenticatorDesc(CanLoginEntity entity, String authCode) {
        if (entity.getAuthCodeKey() != null && entity.getAuthCodeKeyActiveTime() != null) {
            IF.not((boolean)TOTPAuthenticator.authenticate(authCode, entity.getAuthCodeKey()), (int)10004, (Object[])new Object[0]);
        }
        String authKey = TOTPAuthenticator.generateAuthKey();
        Token token = TokenWrapper.getInstance();
        token.setAttribute("accounts.temp.authKey." + entity.getId(), (Serializable)((Object)authKey));
        token.setAttribute("accounts.temp.authKey.validation." + entity.getId(), (Serializable)Long.valueOf(Clock.currentTimeMillis() + 600000L));
        return TOTPAuthenticator.build(authKey, AccountsCommon.getApplicationName(), entity.getName());
    }

    public static <E extends CanLoginEntity> void bindAuthKey(E entity, String authCode, CrudRepository<E, String> repo) {
        Token token = TokenWrapper.getInstance();
        Long validation = (Long)token.getAttribute("accounts.temp.authKey.validation." + entity.getId(), Long.class);
        IF.is((Clock.currentTimeMillis() > validation ? 1 : 0) != 0, (int)10006, (Object[])new Object[0]);
        String authKey = (String)token.getAttribute("accounts.temp.authKey." + entity.getId(), String.class);
        token.removeAttribute("accounts.temp.authKey.validation." + entity.getId());
        token.removeAttribute("accounts.temp.authKey." + entity.getId());
        IF.not((boolean)TOTPAuthenticator.authenticate(authCode, authKey), (int)10004, (Object[])new Object[0]);
        entity.setAuthCodeKey(authKey);
        entity.setAuthCodeKeyActiveTime(Clock.now());
        repo.save(entity);
        token.setAccountCredible(true);
    }

    public static void checkPassword(String password, CanLoginEntity personEntity) {
        IF.not((boolean)AccountsCommon.getEncodedPassword(password).equals(personEntity.getPassword()), (int)10002, (Object[])new Object[0]);
    }

    public static <E extends CanLoginEntity> void resetPassword(E entity, CrudRepository<E, String> repo) {
        entity.setPassword(((PasswordGenerator)PASSWORD_GENERATORS.select((Object)"organization")).encode(null));
        repo.save(entity);
    }

    public static <E extends CanLoginEntity> void resetAuthCode(E entity, CrudRepository<E, String> repo) {
        entity.setAuthCodeKey(null);
        entity.setAuthCodeKeyActiveTime(null);
        repo.save(entity);
    }

    public static boolean isCredible(String authCode, CanLoginEntity entity) {
        if (entity.getAuthCodeKey() != null) {
            IF.not((boolean)TOTPAuthenticator.authenticate(authCode, entity.getAuthCodeKey()), (int)10002, (Object[])new Object[0]);
            return true;
        }
        return false;
    }
}

