/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base32;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.config.Config;
import org.coodex.util.Clock;
import org.coodex.util.DigestHelper;
import org.coodex.util.UUIDHelper;

public class TOTPAuthenticator {
    private static final String TAG_TOTP = "totp";

    public static String generateAuthKey() {
        return new Base32().encodeAsString(new SecureRandom(UUIDHelper.getUUIDBytes()).generateSeed(20));
    }

    public static boolean authenticate(String authCode, String authKey) {
        try {
            if (authCode == null || authKey == null) {
                return false;
            }
            return TOTPAuthenticator.check_code(authKey, Long.parseLong(authCode), Clock.currentTimeMillis() / TimeUnit.SECONDS.toMillis(30L));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static boolean check_code(String secret, long code, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(secret);
        int window = Math.max(Math.min((Integer)Config.getValue((String)"fault.tolerance", (Object)10, (String[])new String[]{TAG_TOTP, ConcreteHelper.getAppSet()}), 10), 1);
        for (int i = -window; i <= window; ++i) {
            long hash = TOTPAuthenticator.buildCode(decodedKey, t + (long)i);
            if (hash != code) continue;
            return true;
        }
        return false;
    }

    public static int buildCode(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        byte[] hash = DigestHelper.hmac((byte[])data, (byte[])key, (String)"HmacSHA1");
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return (int)(truncatedHash %= 1000000L);
    }

    public static String build(String authKey, String app, String userName) {
        String issuerName = (String)Config.getValue((String)"issuer.name", (Object)"coodex.org", (String[])new String[]{TAG_TOTP, ConcreteHelper.getAppSet(), app});
        String serverName = (String)Config.getValue((String)"server.name", (Object)issuerName, (String[])new String[]{TAG_TOTP, ConcreteHelper.getAppSet(), app});
        return String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", TOTPAuthenticator.urlEncoder(serverName), TOTPAuthenticator.urlEncoder(userName), authKey, TOTPAuthenticator.urlEncoder(issuerName));
    }

    private static String urlEncoder(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

