/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.coodex.concrete.accounts.AbstractAdministratorFactory;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.Administrator;
import org.coodex.concrete.accounts.TOTPAuthenticator;
import org.coodex.concrete.common.ClassifiableAccountID;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.config.Config;

public class AdministratorFromProfileFactory
extends AbstractAdministratorFactory {
    public static final String TAG_ADMIN = "administrator";

    @Override
    protected Administrator getAdministrator(String id) {
        return new AdministratorFromProfile(id);
    }

    @Override
    protected Administrator getAdministrator(String id, String tenant) {
        return new AdministratorFromProfile(id, tenant);
    }

    private static class AdministratorFromProfile
    implements Administrator {
        private String uuid;
        private String tenant;

        public AdministratorFromProfile(String uuid) {
            this.uuid = uuid;
        }

        public AdministratorFromProfile(String uuid, String tenant) {
            this.uuid = uuid;
            this.tenant = tenant;
        }

        @Override
        public boolean verify(String password, String authCode) {
            if (password == null || !password.equals(Config.getValue((String)"encoded.password", (Object)AccountsCommon.getDefaultPassword(), (String[])new String[]{AdministratorFromProfileFactory.TAG_ADMIN, ConcreteHelper.getAppSet()}))) {
                return false;
            }
            return TOTPAuthenticator.authenticate(authCode, Config.get((String)"authKey", (String[])new String[]{AdministratorFromProfileFactory.TAG_ADMIN, ConcreteHelper.getAppSet()}));
        }

        public String getName() {
            return (String)Config.getValue((String)"name", (Object)AdministratorFromProfileFactory.TAG_ADMIN, (String[])new String[]{AdministratorFromProfileFactory.TAG_ADMIN, ConcreteHelper.getAppSet()});
        }

        public ClassifiableAccountID getId() {
            return new ClassifiableAccountID(Integer.valueOf(0), this.uuid);
        }

        public Set<String> getRoles() {
            return new HashSet<String>(Arrays.asList(Optional.ofNullable(Config.getArray((String)"roles", (String[])new String[]{AdministratorFromProfileFactory.TAG_ADMIN, ConcreteHelper.getAppSet()})).orElseGet(() -> new String[]{"SystemManager"})));
        }

        public boolean isValid() {
            return (Boolean)Config.getValue((String)"valid", (Object)true, (String[])new String[]{AdministratorFromProfileFactory.TAG_ADMIN, ConcreteHelper.getAppSet()});
        }

        public String getTenant() {
            return this.tenant;
        }
    }
}

