/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts;

import java.io.Serializable;
import org.coodex.concrete.Client;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.TenantAccount;
import org.coodex.concrete.accounts.TenantRPCService;
import org.coodex.concrete.accounts.TenantRPCServiceClient;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.config.Config;
import org.coodex.util.JSONSerializer;

public class TenantRPCServiceClientImpl
implements TenantRPCServiceClient {
    protected Token token = TokenWrapper.getInstance();

    protected TenantRPCService getRPCService() {
        return (TenantRPCService)Client.getInstance(TenantRPCService.class, (String)Config.get((String)"tenant.RPC.service", (String[])new String[]{ConcreteHelper.getAppSet()}));
    }

    public void checkTenant(String tenantAccountName) {
        this.getRPCService().checkTenant(tenantAccountName);
    }

    public TenantAccount getTenantAccountById(String id) {
        return this.getRPCService().getTenantAccountById(id);
    }

    public TenantAccount getTenantAccount(String tenantAccountName) {
        return this.getRPCService().getTenantAccount(tenantAccountName);
    }

    public void login(String tenantAccountName, String password, String authCode) {
        boolean credible = this.getRPCService().login(tenantAccountName, password, authCode);
        this.token.setAccount((Account)this.getTenantAccount(tenantAccountName));
        this.token.setAccountCredible(credible);
    }

    public void updatePassword(String password, String authCode) {
        this.getRPCService().updatePassword(AccountsCommon.getTenant(), password, authCode);
    }

    public String authenticatorDesc(String authCode) {
        return this.getRPCService().authenticatorDesc(AccountsCommon.getTenant(), authCode);
    }

    public void bindAuthKey(String authCode) {
        this.getRPCService().bindAuthKey(AccountsCommon.getTenant(), authCode);
    }

    public <T extends Serializable> void sendMessage(String msgName, T msgBody) {
        this.getRPCService().sendMessage(AccountsCommon.getTenant(), msgName, JSONSerializer.getInstance().toJson(msgBody));
    }
}

