/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.tenant.impl;

import java.util.Calendar;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.TenantAccount;
import org.coodex.concrete.accounts.TenantRPCService;
import org.coodex.concrete.accounts.tenant.entities.AbstractTenantEntity;
import org.coodex.concrete.accounts.tenant.impl.AbstractServerSideTenantAccountFactory;
import org.coodex.concrete.accounts.tenant.repositories.AbstractTenantRepo;
import org.coodex.concrete.common.IF;
import org.coodex.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenantRPCServiceImpl<E extends AbstractTenantEntity>
implements TenantRPCService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTenantRPCServiceImpl.class);
    @Inject
    protected AbstractTenantRepo<E> repo;
    @Inject
    protected AbstractServerSideTenantAccountFactory<E> accountFactory;

    protected E getTenantEntity(String tenantAccountName) {
        return (E)((AbstractTenantEntity)IF.isNull((Object)this.repo.findFirstByAccountName(tenantAccountName), (int)10007, (Object[])new Object[0]));
    }

    public void checkTenant(String tenantAccountName) {
        E tenantEntity = this.getTenantEntity(tenantAccountName);
        Calendar calendar = tenantEntity.getValidation();
        IF.not((tenantEntity.isUsing() && calendar != null && calendar.getTimeInMillis() >= Clock.currentTimeMillis() ? 1 : 0) != 0, (int)10008, (Object[])new Object[0]);
    }

    public TenantAccount getTenantAccount(String tenantAccountName) {
        return this.accountFactory.newAccount(this.getTenantEntity(tenantAccountName).getId());
    }

    public TenantAccount getTenantAccountById(String id) {
        return this.accountFactory.newAccount(((AbstractTenantEntity)IF.isNull(this.repo.findById((Object)id).orElse(null), (int)10007, (Object[])new Object[0])).getId());
    }

    public boolean login(String tenant, String password, String authCode) {
        E tenantEntity = this.getTenantEntity(tenant);
        AccountsCommon.checkPassword((String)password, tenantEntity);
        return AccountsCommon.isCredible((String)authCode, tenantEntity);
    }

    public void updatePassword(String tenant, String password, String authCode) {
        AccountsCommon.updatePassword(this.getTenantEntity(tenant), (String)password, (String)authCode, this.repo);
    }

    public String authenticatorDesc(String tenant, String authCode) {
        return AccountsCommon.getAuthenticatorDesc(this.getTenantEntity(tenant), (String)authCode);
    }

    public void bindAuthKey(String tenant, String authCode) {
        AccountsCommon.bindAuthKey(this.getTenantEntity(tenant), (String)authCode, this.repo);
    }

    public void sendMessage(String tenant, String msgName, String msgBody) {
        log.info("received message: [tenant = {}, msgName = {}, msgBody = {}]", new Object[]{tenant, msgName, msgBody});
    }
}

