/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.tenant.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.inject.Inject;
import org.coodex.commons.jpa.springdata.PageHelper;
import org.coodex.commons.jpa.springdata.SpecCommon;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.tenant.api.AbstractTenantManagementService;
import org.coodex.concrete.accounts.tenant.entities.AbstractTenantEntity;
import org.coodex.concrete.accounts.tenant.pojo.Tenant;
import org.coodex.concrete.accounts.tenant.pojo.TenantQuery;
import org.coodex.concrete.accounts.tenant.repositories.AbstractTenantRepo;
import org.coodex.concrete.api.pojo.PageResult;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.IF;
import org.coodex.copier.Copier;
import org.coodex.copier.TwoWayCopier;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

public abstract class AbstractTenantManagementServiceImpl<T extends Tenant, E extends AbstractTenantEntity>
implements AbstractTenantManagementService<T> {
    @Inject
    protected AbstractTenantRepo<E> tenantRepo;
    @Inject
    protected TwoWayCopier<T, E> copier;

    protected E getTenantEntity(String tenant) {
        return (E)((AbstractTenantEntity)IF.isNull((Object)this.tenantRepo.findFirstByAccountName(tenant), (int)10007, (Object[])new Object[0]));
    }

    public StrID<T> save(String tenant, T tenantInfo) {
        IF.notNull((Object)this.tenantRepo.findFirstByAccountName(tenant), (int)10009, (Object[])new Object[0]);
        tenantInfo.setAccountName(tenant);
        AbstractTenantEntity tenantEntity = (AbstractTenantEntity)this.tenantRepo.save((Object)((AbstractTenantEntity)this.copier.copyA2B(tenantInfo)));
        return new StrID(tenantEntity.getId(), (Object)((Tenant)this.copier.copyB2A((Object)tenantEntity, tenantInfo)));
    }

    public void update(String tenant, T tenantInfo) {
        E tenantEntity = this.getTenantEntity(tenant);
        this.tenantRepo.save((Object)((AbstractTenantEntity)this.copier.copyA2B(tenantInfo, tenantEntity)));
    }

    public PageResult<T> list(org.coodex.concrete.api.pojo.PageRequest<TenantQuery> request) {
        List<Specification<E>> specificationList = this.getListSpecifications((TenantQuery)request.getCondition());
        Page page = specificationList.size() > 0 ? this.tenantRepo.findAll(SpecCommon.and(specificationList), this.toPageable(request)) : this.tenantRepo.findAll(this.toPageable(request));
        return PageHelper.copy((Page)page, (Copier)this.copier.b2aCopier());
    }

    protected Pageable toPageable(org.coodex.concrete.api.pojo.PageRequest<?> request) {
        return PageRequest.of((int)(request.getNum().intValue() - 1), (int)request.getPageSize());
    }

    protected List<Specification<E>> getListSpecifications(TenantQuery query) {
        ArrayList<Specification<Specification>> specificationList = new ArrayList<Specification<Specification>>();
        if (query != null) {
            if (query.isUsing() != null) {
                specificationList.add(SpecCommon.equals((String)"using", (Object)query.isUsing()));
            }
            if (!Common.isBlank((String)query.getAccountNameLike())) {
                specificationList.add(SpecCommon.like((String)"accountName", (String)query.getAccountNameLike()));
            }
            if (!Common.isBlank((String)query.getNameLike())) {
                specificationList.add(SpecCommon.like((String)"name", (String)query.getNameLike()));
            }
        }
        return specificationList;
    }

    public void delete(String tenant) {
        E tenantEntity = this.getTenantEntity(tenant);
        IF.not((boolean)tenantEntity.isUsing(), (int)10011, (Object[])new Object[0]);
        Calendar validation = tenantEntity.getValidation();
        if (validation != null) {
            validation = this.getValidation(validation, 2, 3);
            IF.is((Clock.currentTimeMillis() < validation.getTimeInMillis() ? 1 : 0) != 0, (int)10012, (Object[])new Object[0]);
        }
        this.tenantRepo.delete(tenantEntity);
    }

    public void goDownTo(String tenant, int count, int unit) {
        if (count <= 0) {
            return;
        }
        E tenantEntity = this.getTenantEntity(tenant);
        Calendar validation = this.getValidation(tenantEntity.getValidation(), count, unit);
        if (tenantEntity.isUsing()) {
            tenantEntity.setValidation(validation);
        } else {
            tenantEntity.setSurplus(tenantEntity.getSurplus() + validation.getTimeInMillis() - Clock.currentTimeMillis());
        }
        this.tenantRepo.save(tenantEntity);
    }

    protected Calendar getValidation(Calendar validation, int count, int unit) {
        validation = validation == null ? Clock.now() : (Calendar)validation.clone();
        Calendar result = Clock.now();
        result.setTimeInMillis(Math.max(Clock.currentTimeMillis(), validation.getTimeInMillis()));
        switch (unit) {
            case 1: {
                result.add(2, count);
                break;
            }
            case 2: {
                result.add(2, count * 3);
                break;
            }
            case 3: {
                result.add(1, count);
                break;
            }
            default: {
                result.add(5, count);
            }
        }
        return result;
    }

    public void layUp(String tenant) {
        E tenantEntity = this.getTenantEntity(tenant);
        Calendar validation = tenantEntity.getValidation();
        long now = Clock.currentTimeMillis();
        IF.not((tenantEntity.isUsing() && validation != null && validation.getTimeInMillis() >= now ? 1 : 0) != 0, (int)10008, (Object[])new Object[0]);
        if (validation != null) {
            long remainder = validation.getTimeInMillis() - now;
            tenantEntity.setSurplus(remainder);
            tenantEntity.setValidation(null);
        }
        tenantEntity.setUsing(false);
        this.tenantRepo.save(tenantEntity);
    }

    public void restore(String tenant) {
        E tenantEntity = this.getTenantEntity(tenant);
        long now = Clock.currentTimeMillis();
        IF.is((boolean)tenantEntity.isUsing(), (int)10011, (Object[])new Object[0]);
        Calendar validation = Clock.now();
        validation.setTimeInMillis(now + tenantEntity.getSurplus());
        tenantEntity.setSurplus(0L);
        tenantEntity.setValidation(validation);
        tenantEntity.setUsing(true);
        this.tenantRepo.save(tenantEntity);
    }

    public void resetPassword(String tenant) {
        AccountsCommon.resetPassword(this.getTenantEntity(tenant), this.tenantRepo);
    }

    public void resetAuthCode(String tenant) {
        AccountsCommon.resetAuthCode(this.getTenantEntity(tenant), this.tenantRepo);
    }
}

