/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs;

import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.StringTokenizer;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.api.Signable;
import org.coodex.concrete.apitools.AbstractRenderer;
import org.coodex.concrete.core.signature.SignUtil;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;

public abstract class DocToolkit {
    private final AbstractRenderer render;

    public DocToolkit(AbstractRenderer render) {
        this.render = render;
    }

    public String canonicalName(String name) {
        return this.canonicalName(name, "\\/");
    }

    public String getPojoName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public String getPojoPackage(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    public String canonicalName(String name, String delim) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(name, delim);
        while (stringTokenizer.hasMoreTokens()) {
            String s = stringTokenizer.nextToken();
            if (Common.isBlank((String)s)) continue;
            if (builder.length() > 0) {
                builder.append("_");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public String formatTypeStr(Type t) throws IOException {
        return this.formatTypeStr(t, null);
    }

    public String formatTypeStr(Type t, Class<?> contextClass) throws IOException {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClassLabel((Class)pt.getRawType())).append('<');
            boolean isFirst = true;
            for (Type type : pt.getActualTypeArguments()) {
                if (!isFirst) {
                    builder.append(", ");
                }
                builder.append(this.formatTypeStr(type, contextClass));
                isFirst = false;
            }
            builder.append('>');
            return builder.toString();
        }
        if (t instanceof TypeVariable) {
            if (contextClass != null) {
                return this.formatTypeStr(GenericTypeHelper.solveFromType((TypeVariable)((TypeVariable)t), contextClass));
            }
            TypeVariable typeVariable = (TypeVariable)t;
            StringBuilder builder = new StringBuilder();
            builder.append(typeVariable.getName());
            if (!Object.class.equals((Object)typeVariable.getBounds()[0])) {
                builder.append(" extends ").append(this.formatTypeStr(typeVariable.getBounds()[0]));
            }
            return builder.toString();
        }
        if (t instanceof GenericArrayType) {
            return this.formatTypeStr(((GenericArrayType)t).getGenericComponentType(), contextClass) + "[]";
        }
        if (t instanceof Class) {
            if (((Class)t).isArray()) {
                return this.formatTypeStr(((Class)t).getComponentType(), contextClass) + "[]";
            }
            return this.getClassLabel((Class)t);
        }
        return null;
    }

    protected abstract String getClassLabel(Class<?> var1) throws IOException;

    public AbstractRenderer getRender() {
        return this.render;
    }

    public String camelCase(String str) {
        return Common.camelCase((String)str);
    }

    public String tableSafe(String str) {
        return Common.isBlank((String)str) ? "\u3000" : str;
    }

    public String tableSafeDesc(Description description) {
        return description == null ? "\u3000" : this.tableSafe(description.description());
    }

    public String tableSafeLabel(Description description) {
        return description == null ? "\u3000" : this.tableSafe(description.name());
    }

    public String formatSignable(Signable signable) {
        SignUtil.HowToSign howToSign = SignUtil.howToSign((Signable)signable);
        String clientKeyId = SignUtil.getString((String)"keyId", (String)howToSign.getPaperName(), null);
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n| property | value |\n| ---- | --- |\n").append("| `paperName` | `").append(howToSign.getPaperName()).append("`|\n ").append("| `algorithm` | `").append(howToSign.getAlgorithm()).append("`|\n ");
        if (clientKeyId != null) {
            builder.append("| `keyId` | `").append(clientKeyId).append("`|\n");
        }
        return builder.toString();
    }
}

