/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.service;

import java.io.IOException;
import java.util.List;
import org.coodex.concrete.apitools.APIHelper;
import org.coodex.concrete.apitools.AbstractRenderer;
import org.coodex.concrete.apitools.jaxrs.DocToolkit;
import org.coodex.concrete.apitools.jaxrs.service.ServiceDocToolkit;
import org.coodex.concrete.common.ErrorDefinition;
import org.coodex.concrete.common.ErrorMessageFacade;
import org.coodex.concrete.jaxrs.struct.JaxrsModule;

public class ServiceDocRenderer
extends AbstractRenderer {
    public static final String RENDER_NAME = "JaxRS.doc.backend.gitbook.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/jaxrs/services/doc/gitbook/v1/";
    private final DocToolkit toolkit = new ServiceDocToolkit(this);

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    private void writeSummary(List<JaxrsModule> modules) throws IOException {
        this.writeTo("SUMMARY.md", "SUMMARY.md", "modules", modules, this.toolkit);
    }

    private void writeModuleList(List<JaxrsModule> modules) throws IOException {
        this.writeTo("moduleList.md", "moduleList.md", "modules", modules, this.toolkit);
    }

    private void writeModule(JaxrsModule module) throws IOException {
        this.writeTo("modules" + FS + module.getInterfaceClass().getName() + ".md", "module.md", "module", module, this.toolkit);
    }

    public void writeTo(List<JaxrsModule> modules) throws IOException {
        if (!this.exists("book.json")) {
            this.copyTo("book.json", "book.json");
        }
        if (!this.exists("README.md")) {
            this.copyTo("README.md", "README.md");
        }
        this.writeModuleList(modules);
        for (JaxrsModule module : modules) {
            this.writeModule(module);
        }
        this.writeSummary(modules);
    }

    private void writeErrorInfo(List<ErrorDefinition> errorDefinitions) throws IOException {
        this.writeTo("errorInfo.md", "errorInfo.md", "errorInfo", errorDefinitions);
    }

    @Override
    public void writeTo(String ... packages) throws IOException {
        this.writeTo(APIHelper.loadModules(RENDER_NAME, packages));
        this.writeErrorInfo(ErrorMessageFacade.getAllErrorInfo());
    }
}

