/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.apitools.AbstractRenderer;
import org.coodex.concrete.apitools.jaxrs.DocToolkit;
import org.coodex.concrete.apitools.jaxrs.POJOPropertyInfo;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.jaxrs.struct.JaxrsUnit;
import org.coodex.mock.Mocker;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;

public class ServiceDocToolkit
extends DocToolkit {
    private final Set<String> pojoTypes = new HashSet<String>();

    public ServiceDocToolkit(AbstractRenderer render) {
        super(render);
    }

    @Override
    protected String getClassLabel(Class<?> clz) throws IOException {
        if (ConcreteHelper.isPrimitive(clz) || clz.getPackage().getName().startsWith("java")) {
            return clz.getSimpleName();
        }
        this.buildPojo(clz);
        return "[" + clz.getSimpleName() + "](../pojos/" + this.canonicalName(clz.getName()) + ".md)";
    }

    private void buildPojo(Class<?> clz) throws IOException {
        String name = this.canonicalName(clz.getName());
        if (!this.pojoTypes.contains(name)) {
            this.pojoTypes.add(name);
            ArrayList<POJOPropertyInfo> pojoPropertyInfos = new ArrayList<POJOPropertyInfo>();
            PojoInfo pojoInfo = new PojoInfo(clz);
            for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
                pojoPropertyInfos.add(new POJOPropertyInfo(pojoProperty));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("properties", pojoPropertyInfos);
            map.put("type", clz.getName());
            map.put("tool", this);
            this.getRender().writeTo("pojos/" + this.canonicalName(clz.getName()) + ".md", "pojo.md", map);
        }
    }

    public Set<String> getPojos() {
        return this.pojoTypes;
    }

    public String mockResult(JaxrsUnit unit) {
        String result = Void.TYPE.equals(unit.getReturnType()) ? "" : (String.class.equals((Object)unit.getReturnType()) ? "- **example result**:\n\n```\n" + Mocker.mockMethod((Method)unit.getMethod(), (Type)unit.getDeclaringModule().getInterfaceClass()) + "\n```\n\n" : "- **example result**:\n```json\n" + JSON.toJSONString((Object)Mocker.mockMethod((Method)unit.getMethod(), (Type)unit.getDeclaringModule().getInterfaceClass()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}) + "\n```\n\n");
        return result;
    }

    private boolean isProperty(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isTransient(mod);
    }

    private boolean isProperty(Method method) {
        String name = method.getName();
        return method.getDeclaringClass() != Object.class && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !Modifier.isTransient(method.getModifiers()) && (name.startsWith("get") || name.startsWith("is") && method.getReturnType() == Boolean.TYPE);
    }
}

